/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRClonePool;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import org.apache.commons.collections.ReferenceMap;

public class JRFillCellContents
extends JRFillElementContainer
implements JRCellContents,
JRCloneable {
    private final Map transformedContentsCache;
    private final Map boxContentsCache;
    private final JRClonePool clonePool;
    private JRFillCellContents original;
    private final JRCellContents parentCell;
    private JRBox box;
    private int height;
    private int width;
    private int x;
    private int y;
    private int verticalSpan;
    private byte verticalPositionType = 1;
    private Map templateFrames;
    private final JRStyle initStyle;

    public JRFillCellContents(JRBaseFiller jRBaseFiller, JRCellContents jRCellContents, JRFillObjectFactory jRFillObjectFactory) {
        super(jRBaseFiller, jRCellContents, jRFillObjectFactory);
        this.parentCell = jRCellContents;
        this.box = jRCellContents.getBox();
        this.width = jRCellContents.getWidth();
        this.height = jRCellContents.getHeight();
        this.initStyle = jRFillObjectFactory.getStyle(this.parentCell.getStyle());
        this.initElements();
        this.initConditionalStyles();
        this.initTemplatesMap();
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap();
        this.clonePool = new JRClonePool(this, true, true);
    }

    private void initTemplatesMap() {
        this.templateFrames = new HashMap();
    }

    protected JRFillCellContents(JRFillCellContents jRFillCellContents, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillCellContents, jRFillCloneFactory);
        this.parentCell = jRFillCellContents.parentCell;
        this.box = jRFillCellContents.box;
        this.width = jRFillCellContents.width;
        this.height = jRFillCellContents.height;
        this.initStyle = jRFillCellContents.initStyle;
        this.initElements();
        this.initConditionalStyles();
        this.templateFrames = jRFillCellContents.templateFrames;
        this.transformedContentsCache = new ReferenceMap();
        this.boxContentsCache = new HashMap();
        this.clonePool = new JRClonePool(this, true, true);
        this.verticalPositionType = jRFillCellContents.verticalPositionType;
    }

    public Color getBackcolor() {
        return this.parentCell.getBackcolor();
    }

    public JRBox getBox() {
        return this.box;
    }

    protected void setBox(JRBox jRBox) {
        this.box = jRBox;
        this.initTemplatesMap();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    protected void setHeight(int n) {
        this.height = n;
    }

    protected void setWidth(int n) {
        this.width = n;
    }

    public JRFillCellContents getBoxContents(boolean bl, boolean bl2) {
        boolean bl3;
        if (this.box == null) {
            return this;
        }
        boolean bl4 = bl && this.box.getLeftBorder() == 0 && this.box.getRightBorder() != 0;
        boolean bl5 = bl3 = bl2 && this.box.getTopBorder() == 0 && this.box.getBottomBorder() != 0;
        if (!bl4 && !bl3) {
            return this;
        }
        BoxContents boxContents = new BoxContents(bl4, bl3);
        JRFillCellContents jRFillCellContents = (JRFillCellContents)this.boxContentsCache.get(boxContents);
        if (jRFillCellContents == null) {
            jRFillCellContents = (JRFillCellContents)this.createClone();
            JRBaseBox jRBaseBox = new JRBaseBox(this.box);
            if (bl4) {
                jRBaseBox.setLeftBorder(this.box.getRightBorder());
                jRBaseBox.setLeftBorderColor(this.box.getRightBorderColor());
            }
            if (bl3) {
                jRBaseBox.setTopBorder(this.box.getBottomBorder());
                jRBaseBox.setTopBorderColor(this.box.getBottomBorderColor());
            }
            jRFillCellContents.setBox(jRBaseBox);
            this.boxContentsCache.put(boxContents, jRFillCellContents);
        }
        return jRFillCellContents;
    }

    public JRFillCellContents getTransformedContents(int n, int n2, byte by, byte by2) throws JRException {
        if (this.getHeight() == n2 && this.getWidth() == n) {
            return this;
        }
        if (n2 < this.getHeight() || n < this.getWidth()) {
            throw new JRException("Cannot shrink cell contents.");
        }
        StretchedContents stretchedContents = new StretchedContents(n, n2, by, by2);
        JRFillCellContents jRFillCellContents = (JRFillCellContents)this.transformedContentsCache.get(stretchedContents);
        if (jRFillCellContents == null) {
            jRFillCellContents = (JRFillCellContents)this.createClone();
            jRFillCellContents.transform(n, n2, by, by2);
            jRFillCellContents.setElementsBandBottomY();
            this.transformedContentsCache.put(stretchedContents, jRFillCellContents);
        }
        return jRFillCellContents;
    }

    private void transform(int n, int n2, byte by, byte by2) {
        this.transformElements(n, n2, by, by2);
        this.width = n;
        this.height = n2;
    }

    private void transformElements(int n, int n2, byte by, byte by2) {
        if (!(this.height != n2 && by2 != 1 || this.width != n && by != 1)) {
            return;
        }
        double d = -1.0;
        int n3 = 0;
        switch (by) {
            case 2: {
                n3 = (n - this.width) / 2;
                break;
            }
            case 3: {
                n3 = n - this.width;
                break;
            }
            case 4: {
                d = (double)n / (double)this.width;
            }
        }
        double d2 = -1.0;
        int n4 = 0;
        switch (by2) {
            case 2: {
                n4 = (n2 - this.height) / 2;
                break;
            }
            case 3: {
                n4 = n2 - this.height;
                break;
            }
            case 4: {
                d2 = (double)n2 / (double)this.height;
            }
        }
        JRFillCellContents.transformElements(this.getElements(), d, n3, d2, n4);
    }

    private static void transformElements(JRElement[] jRElementArray, double d, int n, double d2, int n2) {
        if (jRElementArray != null) {
            int n3 = 0;
            while (n3 < jRElementArray.length) {
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[n3];
                if (d != -1.0) {
                    jRFillElement.setX((int)((double)jRFillElement.getX() * d));
                    jRFillElement.setWidth((int)((double)jRFillElement.getWidth() * d));
                }
                if (n != 0) {
                    jRFillElement.setX(jRFillElement.getX() + n);
                }
                if (d2 != -1.0) {
                    jRFillElement.setY((int)((double)jRFillElement.getY() * d2));
                    jRFillElement.setHeight((int)((double)jRFillElement.getHeight() * d2));
                }
                if (n2 != 0) {
                    jRFillElement.setY(jRFillElement.getY() + n2);
                }
                if (jRFillElement instanceof JRFrame) {
                    JRElement[] jRElementArray2 = ((JRFrame)((Object)jRFillElement)).getElements();
                    JRFillCellContents.transformElements(jRElementArray2, d, n, d2, n2);
                }
                ++n3;
            }
        }
    }

    protected void prepare(int n) throws JRException {
        this.initFill();
        this.resetElements();
        this.prepareElements(n, true);
    }

    protected JRPrintFrame fill() throws JRException {
        this.stretchElements();
        this.moveBandBottomElements();
        this.removeBlankElements();
        JRTemplatePrintFrame jRTemplatePrintFrame = new JRTemplatePrintFrame(this.getTemplateFrame());
        jRTemplatePrintFrame.setX(this.x);
        jRTemplatePrintFrame.setY(this.y);
        jRTemplatePrintFrame.setWidth(this.width);
        this.fillElements(jRTemplatePrintFrame);
        this.verticallyPositionElements(jRTemplatePrintFrame);
        jRTemplatePrintFrame.setHeight(this.getPrintHeight());
        return jRTemplatePrintFrame;
    }

    private JRTemplateFrame getTemplateFrame() {
        JRStyle jRStyle = this.getStyle();
        JRTemplateFrame jRTemplateFrame = (JRTemplateFrame)this.templateFrames.get(jRStyle);
        if (jRTemplateFrame == null) {
            jRTemplateFrame = new JRTemplateFrame(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            this.templateFrames.put(jRStyle, jRTemplateFrame);
        }
        return jRTemplateFrame;
    }

    protected void verticallyPositionElements(JRTemplatePrintFrame jRTemplatePrintFrame) {
        int n;
        switch (this.verticalPositionType) {
            case 2: {
                n = (this.getStretchHeight() - this.getContainerHeight()) / 2;
                break;
            }
            case 3: {
                n = this.getStretchHeight() - this.getContainerHeight();
                break;
            }
            default: {
                n = 0;
            }
        }
        if (n != 0) {
            List list = jRTemplatePrintFrame.getElements();
            int n2 = this.getStretchHeight() - n;
            boolean bl = false;
            Iterator iterator = list.iterator();
            while (!bl && iterator.hasNext()) {
                JRPrintElement jRPrintElement = (JRPrintElement)iterator.next();
                boolean bl2 = bl = jRPrintElement.getY() > n2;
            }
            if (!bl) {
                for (JRPrintElement jRPrintElement : list) {
                    jRPrintElement.setY(jRPrintElement.getY() + n);
                }
            }
        }
    }

    protected int getPrintHeight() {
        return this.getStretchHeight() + this.getTopPadding() + this.getBottomPadding();
    }

    protected void stretchTo(int n) {
        this.setStretchHeight(n - this.getTopPadding() - this.getBottomPadding());
    }

    protected int getContainerHeight() {
        return this.getHeight() - this.getTopPadding() - this.getBottomPadding();
    }

    protected int getTopPadding() {
        return this.box == null ? 0 : this.box.getTopPadding();
    }

    protected int getBottomPadding() {
        return this.box == null ? 0 : this.box.getBottomPadding();
    }

    public JRCloneable createClone() {
        JRFillCloneFactory jRFillCloneFactory = new JRFillCloneFactory();
        return this.createClone(jRFillCloneFactory);
    }

    public JRCloneable createClone(JRFillCloneFactory jRFillCloneFactory) {
        return new JRFillCellContents(this, jRFillCloneFactory);
    }

    public JRFillCellContents getWorkingClone() {
        JRFillCellContents jRFillCellContents = (JRFillCellContents)this.clonePool.getClone();
        jRFillCellContents.original = this;
        return jRFillCellContents;
    }

    public void releaseWorkingClone() {
        this.original.clonePool.releaseClone(this);
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getVerticalSpan() {
        return this.verticalSpan;
    }

    public void setVerticalSpan(int n) {
        this.verticalSpan = n;
    }

    public void setVerticalPositionType(byte by) {
        this.verticalPositionType = by;
    }

    protected void evaluate(byte by) throws JRException {
        super.evaluate(by);
        this.evaluateConditionalStyles(by);
    }

    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.parentCell.getDefaultStyleProvider();
    }

    public JRStyle getStyle() {
        JRStyle jRStyle = this.initStyle;
        boolean bl = false;
        if (jRStyle == null) {
            jRStyle = this.filler.getDefaultStyle();
            bl = true;
        }
        JRStyle jRStyle2 = this.getEvaluatedConditionalStyle(jRStyle);
        if (bl && jRStyle2 == jRStyle) {
            jRStyle2 = null;
        }
        return jRStyle2;
    }

    protected void initConditionalStyles() {
        super.initConditionalStyles();
        this.collectConditionalStyle(this.initStyle);
    }

    public Byte getMode() {
        return this.parentCell.getMode();
    }

    protected static class BoxContents {
        final boolean left;
        final boolean top;
        final int hashCode;

        public BoxContents(boolean bl, boolean bl2) {
            this.left = bl;
            this.top = bl2;
            int n = bl ? 1231 : 1237;
            this.hashCode = n = 31 * n + (bl2 ? 1231 : 1237);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            BoxContents boxContents = (BoxContents)object;
            return boxContents.left == this.left && boxContents.top == this.top;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    protected static class StretchedContents {
        final int newHeight;
        final int newWidth;
        final int hashCode;
        final byte xPosition;
        final byte yPosition;

        StretchedContents(int n, int n2, byte by, byte by2) {
            this.newHeight = n2;
            this.newWidth = n;
            this.xPosition = by;
            this.yPosition = by2;
            int n3 = n2;
            n3 = 31 * n3 + n;
            n3 = 31 * n3 + by;
            this.hashCode = n3 = 31 * n3 + by2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            StretchedContents stretchedContents = (StretchedContents)object;
            return stretchedContents.newHeight == this.newHeight && stretchedContents.newWidth == this.newWidth && stretchedContents.xPosition == this.xPosition && stretchedContents.yPosition == this.yPosition;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

