/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression expression, Expression expression2, int n) {
        this.lhs = expression;
        expression.bits |= 0x2000;
        this.expression = expression2;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = n;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        LocalVariableBinding localVariableBinding = this.lhs.localVariableBinding();
        int n = this.expression.nullStatus(flowInfo);
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L && n == 1) {
            flowContext.recordUsingNullReference(blockScope, localVariableBinding, this.lhs, 21, flowInfo);
        }
        flowInfo = ((Reference)this.lhs).analyseAssignment(blockScope, flowContext, flowInfo, this, false).unconditionalInits();
        if (localVariableBinding != null && (localVariableBinding.type.tagBits & 2L) == 0L) {
            switch (n) {
                case 1: {
                    flowInfo.markAsDefinitelyNull(localVariableBinding);
                    break;
                }
                case -1: {
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                    break;
                }
                default: {
                    flowInfo.markAsDefinitelyUnknown(localVariableBinding);
                }
            }
            if (flowContext.initsOnFinally != null) {
                switch (n) {
                    case 1: {
                        flowContext.initsOnFinally.markAsDefinitelyNull(localVariableBinding);
                        break;
                    }
                    case -1: {
                        flowContext.initsOnFinally.markAsDefinitelyNonNull(localVariableBinding);
                        break;
                    }
                    default: {
                        flowContext.initsOnFinally.markAsDefinitelyUnknown(localVariableBinding);
                    }
                }
            }
        }
        return flowInfo;
    }

    void checkAssignment(BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        FieldBinding fieldBinding = this.getLastField(this.lhs);
        if (fieldBinding != null && typeBinding2 != TypeBinding.NULL && typeBinding.isWildcard() && ((WildcardBinding)typeBinding).boundKind != 2) {
            blockScope.problemReporter().wildcardAssignment(typeBinding, typeBinding2, this.expression);
        } else if (fieldBinding != null && !fieldBinding.isStatic() && fieldBinding.declaringClass != null && fieldBinding.declaringClass.isRawType()) {
            blockScope.problemReporter().unsafeRawFieldAssignment(fieldBinding, typeBinding2, this.lhs);
        } else if (typeBinding2.needsUncheckedConversion(typeBinding)) {
            blockScope.problemReporter().unsafeTypeConversion(this.expression, typeBinding2, typeBinding);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        ((Reference)this.lhs).generateAssignment(blockScope, codeStream, this, bl);
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public static Binding getDirectBinding(Expression expression) {
        if (expression instanceof SingleNameReference) {
            return ((SingleNameReference)expression).binding;
        }
        if (expression instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && !(fieldReference.receiver instanceof QualifiedThisReference)) {
                return fieldReference.binding;
            }
        } else if (expression instanceof Assignment) {
            Expression expression2 = ((Assignment)expression).lhs;
            if ((expression2.bits & 0x2000) != 0) {
                return Assignment.getDirectBinding(((Assignment)expression).lhs);
            }
            if (expression instanceof PrefixExpression) {
                return Assignment.getDirectBinding(((Assignment)expression).lhs);
            }
        }
        return null;
    }

    FieldBinding getLastField(Expression expression) {
        if (expression instanceof SingleNameReference) {
            if ((expression.bits & 7) == 1) {
                return (FieldBinding)((SingleNameReference)expression).binding;
            }
        } else {
            if (expression instanceof FieldReference) {
                return ((FieldReference)expression).binding;
            }
            if (expression instanceof QualifiedNameReference) {
                QualifiedNameReference qualifiedNameReference = (QualifiedNameReference)expression;
                if (qualifiedNameReference.otherBindings == null && (expression.bits & 7) == 1) {
                    return (FieldBinding)qualifiedNameReference.binding;
                }
                return qualifiedNameReference.otherBindings[qualifiedNameReference.otherBindings.length - 1];
            }
        }
        return null;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return this.expression.nullStatus(flowInfo);
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Assignment.printIndent(n, stringBuffer);
        return this.printExpressionNoParenthesis(n, stringBuffer);
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        return this.printExpressionNoParenthesis(0, stringBuffer).append(')');
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.lhs.printExpression(n, stringBuffer).append(" = ");
        return this.expression.printExpression(0, stringBuffer);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = Constant.NotAConstant;
        if (!(this.lhs instanceof Reference) || this.lhs.isThis()) {
            blockScope.problemReporter().expressionShouldBeAVariable(this.lhs);
            return null;
        }
        TypeBinding typeBinding = this.lhs.resolveType(blockScope);
        this.expression.setExpectedType(typeBinding);
        if (typeBinding != null) {
            this.resolvedType = typeBinding.capture(blockScope, this.sourceEnd);
        }
        TypeBinding typeBinding2 = this.expression.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        Binding binding = Assignment.getDirectBinding(this.lhs);
        if (binding != null && binding == Assignment.getDirectBinding(this.expression)) {
            blockScope.problemReporter().assignmentHasNoEffect(this, binding.shortReadableName());
        }
        if (typeBinding != typeBinding2) {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding2);
        }
        if (this.expression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, typeBinding2.id) || typeBinding2.isCompatibleWith(typeBinding)) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            this.checkAssignment(blockScope, typeBinding, typeBinding2);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4000) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return this.resolvedType;
        }
        if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding) || typeBinding2.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding.isBaseType() && this.expression.isConstantValueOfTypeAssignableToType(typeBinding2, blockScope.environment().computeBoxingType(typeBinding))) {
            this.expression.computeConversion(blockScope, typeBinding, typeBinding2);
            if (this.expression instanceof CastExpression && (this.expression.bits & 0x4000) == 0) {
                CastExpression.checkNeedForAssignedCast(blockScope, typeBinding, (CastExpression)this.expression);
            }
            return this.resolvedType;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.expression);
        return typeBinding;
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeBinding typeBinding2 = super.resolveTypeExpecting(blockScope, typeBinding);
        if (typeBinding2 == null) {
            return null;
        }
        TypeBinding typeBinding3 = this.resolvedType;
        TypeBinding typeBinding4 = this.expression.resolvedType;
        if (typeBinding == TypeBinding.BOOLEAN && typeBinding3 == TypeBinding.BOOLEAN && (this.lhs.bits & 0x2000) != 0) {
            blockScope.problemReporter().possibleAccidentalBooleanAssignment(this);
        }
        this.checkAssignment(blockScope, typeBinding3, typeBinding4);
        return typeBinding2;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public LocalVariableBinding localVariableBinding() {
        return this.lhs.localVariableBinding();
    }
}

