/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.FloatUtil;

public class DoubleLiteral
extends NumberLiteral {
    double value;

    public DoubleLiteral(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public void computeConstant() {
        Double d;
        try {
            d = Double.valueOf(String.valueOf(this.source));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d2 = FloatUtil.valueOfHexDoubleLiteral(this.source);
                if (d2 == Double.POSITIVE_INFINITY) {
                    return;
                }
                if (Double.isNaN(d2)) {
                    return;
                }
                this.value = d2;
                this.constant = DoubleConstant.fromValue(d2);
            }
            catch (NumberFormatException numberFormatException2) {}
            return;
        }
        double d3 = d;
        if (d3 > Double.MAX_VALUE) {
            return;
        }
        if (d3 < Double.MIN_VALUE) {
            boolean bl = false;
            int n = 0;
            block10: while (n < this.source.length) {
                switch (this.source[n]) {
                    case '.': 
                    case '0': {
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        bl = true;
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (!bl) break block10;
                        return;
                    }
                    case 'P': 
                    case 'p': {
                        break block10;
                    }
                    default: {
                        return;
                    }
                }
                ++n;
            }
        }
        this.value = d3;
        this.constant = DoubleConstant.fromValue(this.value);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.DOUBLE;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

