/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.block.BlockFrame;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public class LineBorder
implements BlockFrame,
Serializable {
    private transient Paint paint;
    private transient Stroke stroke;
    private RectangleInsets insets;

    public LineBorder() {
        this(Color.black, new BasicStroke(1.0f), new RectangleInsets(1.0, 1.0, 1.0, 1.0));
    }

    public LineBorder(Paint paint, Stroke stroke, RectangleInsets rectangleInsets) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'insets' argument.");
        }
        this.paint = paint;
        this.stroke = stroke;
        this.insets = rectangleInsets;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public RectangleInsets getInsets() {
        return this.insets;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        double d3 = this.insets.calculateTopInset(d2);
        double d4 = this.insets.calculateBottomInset(d2);
        double d5 = this.insets.calculateLeftInset(d);
        double d6 = this.insets.calculateRightInset(d);
        double d7 = rectangle2D.getX();
        double d8 = rectangle2D.getY();
        double d9 = d7 + d5 / 2.0;
        double d10 = d7 + d - d6 / 2.0;
        double d11 = d8 + d2 - d4 / 2.0;
        double d12 = d8 + d3 / 2.0;
        graphics2D.setPaint(this.getPaint());
        graphics2D.setStroke(this.getStroke());
        Line2D.Double double_ = new Line2D.Double();
        if (d3 > 0.0) {
            ((Line2D)double_).setLine(d9, d12, d10, d12);
            graphics2D.draw(double_);
        }
        if (d4 > 0.0) {
            ((Line2D)double_).setLine(d9, d11, d10, d11);
            graphics2D.draw(double_);
        }
        if (d5 > 0.0) {
            ((Line2D)double_).setLine(d9, d11, d9, d12);
            graphics2D.draw(double_);
        }
        if (d6 > 0.0) {
            ((Line2D)double_).setLine(d10, d11, d10, d12);
            graphics2D.draw(double_);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LineBorder)) {
            return false;
        }
        LineBorder lineBorder = (LineBorder)object;
        if (!PaintUtilities.equal(this.paint, lineBorder.paint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.stroke, lineBorder.stroke)) {
            return false;
        }
        return this.insets.equals(lineBorder.insets);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
    }
}

