/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class LookupPaintScale
implements PaintScale,
PublicCloneable,
Serializable {
    private double lowerBound;
    private double upperBound;
    private transient Paint defaultPaint;
    private List lookupTable;

    public LookupPaintScale() {
        this(0.0, 1.0, Color.lightGray);
    }

    public LookupPaintScale(double d, double d2, Paint paint) {
        if (d >= d2) {
            throw new IllegalArgumentException("Requires lowerBound < upperBound.");
        }
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.lowerBound = d;
        this.upperBound = d2;
        this.defaultPaint = paint;
        this.lookupTable = new ArrayList();
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void add(Number number, Paint paint) {
        PaintItem paintItem = new PaintItem(number, paint);
        int n = Collections.binarySearch(this.lookupTable, paintItem);
        if (n >= 0) {
            this.lookupTable.set(n, paintItem);
        } else {
            this.lookupTable.add(-(n + 1), paintItem);
        }
    }

    public Paint getPaint(double d) {
        if (d < this.lowerBound) {
            return this.defaultPaint;
        }
        if (d > this.upperBound) {
            return this.defaultPaint;
        }
        Paint paint = this.defaultPaint;
        int n = this.lookupTable.size();
        boolean bl = false;
        while (n > 0 && !bl) {
            PaintItem paintItem = (PaintItem)this.lookupTable.get(--n);
            if (!(d >= paintItem.value.doubleValue())) continue;
            paint = paintItem.paint;
            bl = true;
        }
        return paint;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LookupPaintScale)) {
            return false;
        }
        LookupPaintScale lookupPaintScale = (LookupPaintScale)object;
        if (this.lowerBound != lookupPaintScale.lowerBound) {
            return false;
        }
        if (this.upperBound != lookupPaintScale.upperBound) {
            return false;
        }
        if (!PaintUtilities.equal(this.defaultPaint, lookupPaintScale.defaultPaint)) {
            return false;
        }
        return this.lookupTable.equals(lookupPaintScale.lookupTable);
    }

    public Object clone() throws CloneNotSupportedException {
        LookupPaintScale lookupPaintScale = (LookupPaintScale)super.clone();
        lookupPaintScale.lookupTable = new ArrayList(this.lookupTable);
        return lookupPaintScale;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.defaultPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.defaultPaint = SerialUtilities.readPaint(objectInputStream);
    }

    class PaintItem
    implements Comparable,
    Serializable {
        Number value;
        transient Paint paint;

        public PaintItem(Number number, Paint paint) {
            this.value = number;
            this.paint = paint;
        }

        public int compareTo(Object object) {
            double d;
            PaintItem paintItem = (PaintItem)object;
            double d2 = this.value.doubleValue();
            if (d2 > (d = paintItem.value.doubleValue())) {
                return 1;
            }
            if (d2 < d) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof PaintItem)) {
                return false;
            }
            PaintItem paintItem = (PaintItem)object;
            if (!this.value.equals(paintItem.value)) {
                return false;
            }
            return PaintUtilities.equal(this.paint, paintItem.paint);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            SerialUtilities.writePaint(this.paint, objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.paint = SerialUtilities.readPaint(objectInputStream);
        }
    }
}

