/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.pagamentos;

import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class Pagamento
extends ObjetoNegocio {
    public static final String PAGAMENTO_INSTRUCAO_BR = "01";
    public static final String PAGAMENTO_INSTRUCAO_EX = "02";
    public static final String PAGAMENTO_FONOAUDIOLOGO_BR = "09";
    public static final String PAGAMENTO_MEDICO_BR = "10";
    public static final String PAGAMENTO_DENTISTA_BR = "11";
    public static final String PAGAMENTO_PSICOLOGO_BR = "12";
    public static final String PAGAMENTO_FISIOTERAPEUTA_BR = "13";
    public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR = "14";
    public static final String PAGAMENTO_MEDICO_EX = "15";
    public static final String PAGAMENTO_DENTISTA_EX = "16";
    public static final String PAGAMENTO_PSICOLOGO_EX = "17";
    public static final String PAGAMENTO_FISIOTERAPEUTA_EX = "18";
    public static final String PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX = "19";
    public static final String PAGAMENTO_FONOAUDIOLOGO_EX = "20";
    public static final String PAGAMENTO_HOSPITAL_BR = "21";
    public static final String PAGAMENTO_HOSPITAL_EX = "22";
    public static final String PAGAMENTO_PLANOSAUDE_BR = "26";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_BR = "30";
    public static final String PAGAMENTO_PENSAOALIMENTICIA_EX = "31";
    public static final String PAGAMENTO_PENSAODIVORCIO_BR = "33";
    public static final String PAGAMENTO_PENSAODIVORCIO_EX = "34";
    public static final String PAGAMENTO_PREVIPRIVADA = "36";
    public static final String PAGAMENTO_FUNPRESP = "37";
    public static final String PAGAMENTO_FAPI = "38";
    public static final String PAGAMENTO_ADVOGADOS = "60";
    public static final String PAGAMENTO_ADVOGADOS_TRAB = "61";
    public static final String PAGAMENTO_ADVOGADOS_HONORARIOS = "62";
    public static final String PAGAMENTO_PROFLIBERAL = "66";
    public static final String PAGAMENTO_ALUGUEIS = "70";
    public static final String PAGAMENTO_ADMINISTRADOR_IMOVEL = "71";
    public static final String PAGAMENTO_CORRETOR_IMOVEL = "72";
    public static final String PAGAMENTO_ARRENDRURAL = "76";
    public static final String PAGAMENTO_OUTROS = "99";
    public static final String PERC_LIMITE_DEDUCAO_CONTRIBUICAO_PREV_PRIV_FAPI = "0,12";
    public static final String PERC_LIMITE_DEDUCAO_INCENTIVO = "0,06";
    public static final String LIMITE_DESPESAS_INSTRUCAO = "3.561,50";
    public static final String NOME_CODIGO = "C\u00f3digo";
    public static final String NOME_TIPO = "Tipo";
    public static final String NOME_PAIS = "Localiza\u00e7\u00e3o(Pa\u00eds)";
    private Codigo codigo = new Codigo(this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoPagamentos());
    private Alfa dependenteOuAlimentando = new Alfa(this, "Dependente/Alimentando", 20);
    private Alfa nomeBeneficiario = new Alfa(this, "Nome do Benefici\u00e1rio", 60);
    private NI niBeneficiario = new NI(this, "CPF ou CNPJ do Benefici\u00e1rio");
    private Valor valorPago = new Valor(this, "Valor Pago");
    private Valor parcelaNaoDedutivel = new Valor(this, "Parcela N\u00e3o Dedut\u00edvel/Valor Reembolsado");
    private Alfa tipo = new Alfa(this, "Tipo");
    private Alfa descricao = new Alfa(this, "Descri\u00e7\u00e3o");
    private Codigo pais = new Codigo(this, "Localiza\u00e7\u00e3o(Pa\u00eds)", CadastroTabelasIRPF.recuperarPaises());
    public static String TIPO_TITULAR = "T";
    public static String TIPO_DEPENDENTE = "D";
    public static String TIPO_ALIMENTANDO = "A";
    public static String TIPO_PADRAO = TIPO_TITULAR;

    public Pagamento(final DeclaracaoIRPF declaracaoIRPF) {
        final IdentificadorDeclaracao identificadorDeclaracao = declaracaoIRPF.getIdentificadorDeclaracao();
        this.getCodigo().setColunaFiltro(1);
        this.getPais().setColunaFiltro(1);
        this.tipo.addObservador(new Observador(){

            public void notifica(Object object, String string, Object object2, Object object3) {
                if (string.equals(Pagamento.NOME_TIPO) && !((String)object2).equals("")) {
                    Pagamento.this.getDependenteOuAlimentando().clear();
                }
            }
        });
        this.getCodigo().addValidador(new ValidadorNaoNulo(3, this.tab.msg("pagamento_codigo")){

            public RetornoValidacao validarImplementado() {
                if (identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNomeBeneficiario().addValidador(new ValidadorNaoNulo(3, ""){

            public RetornoValidacao validarImplementado() {
                if (identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                Pagamento.this.getNiBeneficiario().validar();
                if (Pagamento.this.getNomeBeneficiario().isVazio() && Pagamento.this.getNiBeneficiario().isValido()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(tab.msg("pagamento_beneficiario"), 2);
                }
                if (Pagamento.this.getNomeBeneficiario().isVazio() && !Pagamento.this.getNiBeneficiario().isValido()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(tab.msg("pagamento_beneficiario_ni_invalido"), 3);
                }
                return null;
            }
        });
        this.getNiBeneficiario().addValidador(new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                if (identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                String string = Pagamento.this.getCodigo().getConteudoAtual(0);
                String string2 = null;
                if (string.equals(Pagamento.PAGAMENTO_INSTRUCAO_BR) || string.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_BR) || string.equals(Pagamento.PAGAMENTO_MEDICO_BR) || string.equals(Pagamento.PAGAMENTO_DENTISTA_BR) || string.equals(Pagamento.PAGAMENTO_PSICOLOGO_BR) || string.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_BR) || string.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR) || string.equals(Pagamento.PAGAMENTO_HOSPITAL_BR) || string.equals(Pagamento.PAGAMENTO_PLANOSAUDE_BR)) {
                    string2 = "pagamento_nibeneficiario_1";
                } else if (string.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) || string.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX) || string.equals(Pagamento.PAGAMENTO_PREVIPRIVADA) || string.equals(Pagamento.PAGAMENTO_FAPI) || string.equals(Pagamento.PAGAMENTO_ADVOGADOS) || string.equals(Pagamento.PAGAMENTO_ADVOGADOS_TRAB) || string.equals(Pagamento.PAGAMENTO_ADVOGADOS_HONORARIOS) || string.equals(Pagamento.PAGAMENTO_PROFLIBERAL) || string.equals(Pagamento.PAGAMENTO_ALUGUEIS) || string.equals(Pagamento.PAGAMENTO_ADMINISTRADOR_IMOVEL) || string.equals(Pagamento.PAGAMENTO_CORRETOR_IMOVEL) || string.equals(Pagamento.PAGAMENTO_ARRENDRURAL)) {
                    string2 = "pagamento_nibeneficiario_2";
                }
                RetornoValidacao retornoValidacao = Validador.validarNI(UtilitariosString.retiraMascara(this.getInformacao().getConteudoFormatado()));
                if ((Pagamento.this.getNiBeneficiario().isVazio() || retornoValidacao != null) && string2 != null) {
                    return new RetornoValidacao(tab.msg(string2), 2);
                }
                return null;
            }
        });
        this.getParcelaNaoDedutivel().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                String string = Pagamento.this.getCodigo().getConteudoAtual(0);
                if ((string.equals(Pagamento.PAGAMENTO_INSTRUCAO_BR) || string.equals(Pagamento.PAGAMENTO_INSTRUCAO_EX) || string.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_BR) || string.equals(Pagamento.PAGAMENTO_FONOAUDIOLOGO_EX) || string.equals(Pagamento.PAGAMENTO_MEDICO_BR) || string.equals(Pagamento.PAGAMENTO_MEDICO_EX) || string.equals(Pagamento.PAGAMENTO_DENTISTA_BR) || string.equals(Pagamento.PAGAMENTO_DENTISTA_EX) || string.equals(Pagamento.PAGAMENTO_PSICOLOGO_BR) || string.equals(Pagamento.PAGAMENTO_PSICOLOGO_EX) || string.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_BR) || string.equals(Pagamento.PAGAMENTO_FISIOTERAPEUTA_EX) || string.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_BR) || string.equals(Pagamento.PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || string.equals(Pagamento.PAGAMENTO_HOSPITAL_BR) || string.equals(Pagamento.PAGAMENTO_HOSPITAL_EX) || string.equals(Pagamento.PAGAMENTO_PLANOSAUDE_BR) || string.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_BR) || string.equals(Pagamento.PAGAMENTO_PENSAOALIMENTICIA_EX)) && Pagamento.this.getParcelaNaoDedutivel().comparacao(">", Pagamento.this.getValorPago())) {
                    return new RetornoValidacao(tab.msg("pagamento_valor_reembolsado"), 3);
                }
                return null;
            }
        });
        this.getValorPago().addValidador(new ValidadorNaoNulo(3){

            public RetornoValidacao validarImplementado() {
                if (identificadorDeclaracao.getTipoDeclaracao().asString().equals("1")) {
                    return null;
                }
                if (Pagamento.this.getCodigo().isVazio() && Pagamento.this.getNomeBeneficiario().isVazio() && Pagamento.this.getNiBeneficiario().isVazio() && Pagamento.this.getParcelaNaoDedutivel().isVazio()) {
                    return null;
                }
                this.setMensagemValidacao(tab.msg("pagamento_valor_pago"));
                return super.validarImplementado();
            }
        });
        this.getDependenteOuAlimentando().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (TIPO_TITULAR.equals(Pagamento.this.getTipo().asString())) {
                    if (Pagamento.this.getDependenteOuAlimentando().isVazio()) {
                        return new RetornoValidacao(tab.msg("pagamento_titular_nao_vazio"));
                    }
                } else if (TIPO_DEPENDENTE.equals(Pagamento.this.getTipo().asString()) ? !declaracaoIRPF.getDependentes().isExisteNome(Pagamento.this.getDependenteOuAlimentando().asString()) : TIPO_ALIMENTANDO.equals(Pagamento.this.getTipo().asString()) && !declaracaoIRPF.getAlimentandos().isExisteNome(Pagamento.this.getDependenteOuAlimentando().asString())) {
                    return new RetornoValidacao(tab.msg("pagamento_dependente_alimentando"), 3);
                }
                return null;
            }
        });
        this.getDependenteOuAlimentando().addValidador(new ValidadorNaoNulo(3, this.tab.msg("pagamento_dependente_alimentando")){

            public RetornoValidacao validarImplementado() {
                Pagamento.this.getCodigo().getConteudoAtual(0);
                if (TIPO_TITULAR.equals(Pagamento.this.getTipo().asString()) || "".equals(Pagamento.this.getTipo().asString()) || " ".equals(Pagamento.this.getTipo().asString())) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getNiBeneficiario().addValidador(new ValidadorNI(3));
        this.getNiBeneficiario().addValidador(new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.getNiBeneficiario().asString().equals(identificadorDeclaracao.getCpf().asString())) {
                    return new RetornoValidacao(tab.msg("pagamento_cpf_beneficiario_igual"), 3);
                }
                return null;
            }
        });
        this.getPais().addValidador(new ValidadorNaoNulo(2){

            public RetornoValidacao validarImplementado() {
                if (Pagamento.this.ehExterior() && (Pagamento.this.getPais().isVazio() || Pagamento.this.getPais().getConteudoAtual(0).equals("105"))) {
                    return new RetornoValidacao(tab.msg("pagamento_pais_branco"), 2);
                }
                return null;
            }
        });
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getTipo() {
        return this.tipo;
    }

    public boolean ehExterior() {
        String string = this.getCodigo().getConteudoAtual(0);
        return string.equals(PAGAMENTO_INSTRUCAO_EX) || string.equals(PAGAMENTO_MEDICO_EX) || string.equals(PAGAMENTO_DENTISTA_EX) || string.equals(PAGAMENTO_PSICOLOGO_EX) || string.equals(PAGAMENTO_FISIOTERAPEUTA_EX) || string.equals(PAGAMENTO_TERAPEUTA_OCUPACIONAL_EX) || string.equals(PAGAMENTO_FONOAUDIOLOGO_EX) || string.equals(PAGAMENTO_HOSPITAL_EX) || string.equals(PAGAMENTO_PENSAOALIMENTICIA_EX) || string.equals(PAGAMENTO_PENSAODIVORCIO_EX);
    }

    public boolean ehTitularBrasil() {
        return this.getTipo().asString().equals(TIPO_TITULAR) && !this.ehExterior();
    }

    public boolean ehTitularExterior() {
        return this.getTipo().asString().equals(TIPO_TITULAR) && this.ehExterior();
    }

    public boolean ehDependenteBrasil() {
        return this.getTipo().asString().equals(TIPO_DEPENDENTE) && !this.ehExterior();
    }

    public boolean ehDependenteExterior() {
        return this.getTipo().asString().equals(TIPO_DEPENDENTE) && this.ehExterior();
    }

    public boolean ehAlimentandoBrasil() {
        return this.getTipo().asString().equals(TIPO_ALIMENTANDO) && !this.ehExterior();
    }

    public boolean ehAlimentandoExterior() {
        return this.getTipo().asString().equals(TIPO_ALIMENTANDO) && this.ehExterior();
    }

    public boolean ehInstrucao() {
        String string = this.getCodigo().getConteudoAtual(0);
        return string.equals(PAGAMENTO_INSTRUCAO_BR) || string.equals(PAGAMENTO_INSTRUCAO_EX);
    }

    public NI getNiBeneficiario() {
        return this.niBeneficiario;
    }

    public Alfa getNomeBeneficiario() {
        return this.nomeBeneficiario;
    }

    public Valor getParcelaNaoDedutivel() {
        return this.parcelaNaoDedutivel;
    }

    public Valor getValorPago() {
        return this.valorPago;
    }

    public Alfa getDependenteOuAlimentando() {
        return this.dependenteOuAlimentando;
    }

    public Alfa getDescricao() {
        return this.descricao;
    }

    public Codigo getPais() {
        return this.pais;
    }

    protected List recuperarListaCamposPendencia() {
        List list = super.recuperarListaCamposPendencia();
        list.add(this.codigo);
        list.add(this.dependenteOuAlimentando);
        list.add(this.nomeBeneficiario);
        list.add(this.niBeneficiario);
        list.add(this.valorPago);
        list.add(this.parcelaNaoDedutivel);
        list.add(this.pais);
        return list;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarCamposInformacao()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }
}

