// $Id: MultiMeta.java,v 1.1 1998/06/05 12:22:46 oliva Exp $

/* Copyright 1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

import BR.unicamp.Guarana.*;
import java.util.Hashtable;

/**
 * This meta-object shows how to behave when a single meta-object must
 * interact with multiple base-level objects.
 *
 * @author Alexandre Oliva
 * @version $Revision: 1.1 $
 */
public abstract class MultiMeta extends MetaObject {
    protected Hashtable objDict = new Hashtable();
    protected static class ObjData {
	public OperationFactory opf;
	public int initcount = 1;
	public ObjData(OperationFactory opf) { this.opf = opf; }
	public synchronized void initialize(OperationFactory opf)
	{ this.opf = opf; ++initcount; }
	public synchronized boolean release() { return --initcount == 0; }
    }
    public synchronized void
	initialize(final OperationFactory opf, final Object ob) {
	final HashWrapper obw = new HashWrapper(ob);
	final ObjData od = (ObjData)objDict.get(obw);
	if (od != null) od.initialize(opf);
	else objDict.put(obw, new ObjData(opf));
    }
    public synchronized void release(final Object ob) {
	final HashWrapper obw = new HashWrapper(ob);
	final ObjData od = (ObjData)objDict.get(obw);
	if (od != null && od.release())
	    objDict.remove(ob);
    }
}
