// $Id: NewObject.java,v 1.6 1998/06/08 10:14:16 oliva Exp $

/* Copyright 1997,1998 Alexandre Oliva <oliva@dcc.unicamp.br>
 *
 * This file is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package BR.unicamp.Guarana;

/** This Message is implicitly Broadcast to a Class' MetaObject after
    an instance of the Class is allocated and the creator's MetaObject
    is given the opportunity to associate it with a MetaObject, but
    before the object is actually initialized.

    <p>It allows the Class' meta-configuration to try to reconfigure
    its instances' meta-configurations.

    @see Guarana#broadcast
    @see Guarana#reconfigure
    @see MetaObject#configure

    @author Alexandre Oliva
    @version $Revision: 1.6 $  */
public class NewObject implements Message {
  /** The Object that was allocated but was not initialized yet.  */
  public final Object object;
  
  /** Creates a Message that informs a class that a new instance of it
      has been allocated, and it to be initialized soon.

      @param object the newly-allocated Object.  */
  public NewObject(Object object) {
    this.object = object;
  }

  /** Obtains a reference to the allocated Object.

      @return a reference to the allocated Object.  */
  public Object getObject() {
    return object;
  }
}
