/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.TextRenderer;
import net.sf.jasperreports.engine.util.JRGraphEnvInitializer;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRStyledText;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    private static final int ELEMENT_RECTANGLE_PADDING = 3;
    private static final float DEFAULT_ZOOM = 1.0f;
    public static final String MINIMIZE_PRINTER_JOB_SIZE = "net.sf.jasperreports.export.graphics2d.min.job.size";
    protected Graphics2D grx = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected float zoom = 1.0f;
    protected TextRenderer textRenderer = null;
    private static final double THIN_CORNER_OFFSET = 0.25;
    private static final double ONE_POINT_CORNER_OFFSET = 0.5;
    private static final Stroke STROKE_THIN = new BasicStroke(0.5f);
    private static final Stroke STROKE_1_POINT = new BasicStroke(1.0f);
    private static final Stroke STROKE_2_POINT = new BasicStroke(2.0f);
    private static final Stroke STROKE_4_POINT = new BasicStroke(4.0f);
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);
    private static final Stroke BORDER_STROKE_THIN = new BasicStroke(0.5f, 0, 0);
    private static final Stroke BORDER_STROKE_1_POINT = new BasicStroke(1.0f, 0, 0);
    private static final Stroke BORDER_STROKE_DOTTED = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 3.0f}, 0.0f);

    public JRGraphics2DExporter() throws JRException {
        JRGraphEnvInitializer.initializeGraphEnv();
    }

    public void exportReport() throws JRException {
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        try {
            this.setExportContext();
            this.setInput();
            this.setPageRange();
            this.setTextRenderer();
            this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
            if (this.grx == null) {
                throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
            }
            Float f = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO);
            if (f != null) {
                this.zoom = f.floatValue();
                if (this.zoom <= 0.0f) {
                    throw new JRException("Invalid zoom ratio : " + this.zoom);
                }
            } else {
                this.zoom = 1.0f;
            }
            this.exportReportToGraphics2D();
        }
        finally {
            this.resetExportContext();
        }
    }

    protected void setTextRenderer() {
        boolean bl = true;
        Boolean bl2 = (Boolean)this.parameters.get(JRGraphics2DExporterParameter.MINIMIZE_PRINTER_JOB_SIZE);
        bl = bl2 == null ? JRProperties.getBooleanProperty(MINIMIZE_PRINTER_JOB_SIZE) : bl2;
        this.textRenderer = new TextRenderer(bl);
    }

    public void exportReportToGraphics2D() throws JRException {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.globalOffsetX, this.globalOffsetY);
        affineTransform.scale(this.zoom, this.zoom);
        this.grx.transform(affineTransform);
        List list = this.jasperPrint.getPages();
        if (list != null) {
            Shape shape = this.grx.getClip();
            this.grx.clip(new Rectangle(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight()));
            try {
                JRPrintPage jRPrintPage = (JRPrintPage)list.get(this.startPageIndex);
                this.exportPage(jRPrintPage);
            }
            finally {
                this.grx.setClip(shape);
            }
        }
    }

    protected void exportPage(JRPrintPage jRPrintPage) throws JRException {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        List list = jRPrintPage.getElements();
        this.exportElements(list);
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection collection) throws JRException {
        if (collection != null && collection.size() > 0) {
            Shape shape = this.grx.getClip();
            for (JRPrintElement jRPrintElement : collection) {
                if (!shape.intersects(jRPrintElement.getX() + this.getOffsetX() - 3, jRPrintElement.getY() + this.getOffsetY() - 3, jRPrintElement.getWidth() + 6, jRPrintElement.getHeight() + 6)) continue;
                if (jRPrintElement instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)jRPrintElement);
                    continue;
                }
                if (jRPrintElement instanceof JRPrintText) {
                    this.exportText((JRPrintText)jRPrintElement);
                    continue;
                }
                if (!(jRPrintElement instanceof JRPrintFrame)) continue;
                this.exportFrame((JRPrintFrame)jRPrintElement);
            }
        }
    }

    protected void exportLine(JRPrintLine jRPrintLine) {
        this.grx.setColor(jRPrintLine.getForecolor());
        Stroke stroke = JRGraphics2DExporter.getStroke(jRPrintLine.getPen());
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.translate(0.5, 0.5);
            if (jRPrintLine.getDirection() == 1) {
                this.grx.drawLine(jRPrintLine.getX() + this.getOffsetX(), jRPrintLine.getY() + this.getOffsetY(), jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth() - 1, jRPrintLine.getY() + this.getOffsetY() + jRPrintLine.getHeight() - 1);
            } else {
                this.grx.drawLine(jRPrintLine.getX() + this.getOffsetX(), jRPrintLine.getY() + this.getOffsetY() + jRPrintLine.getHeight() - 1, jRPrintLine.getX() + this.getOffsetX() + jRPrintLine.getWidth() - 1, jRPrintLine.getY() + this.getOffsetY());
            }
            this.grx.translate(-0.5, -0.5);
        }
    }

    protected void exportRectangle(JRPrintRectangle jRPrintRectangle) {
        if (jRPrintRectangle.getMode() == 1) {
            this.grx.setColor(jRPrintRectangle.getBackcolor());
            if (jRPrintRectangle.getRadius() > 0) {
                this.grx.fillRoundRect(jRPrintRectangle.getX() + this.getOffsetX(), jRPrintRectangle.getY() + this.getOffsetY(), jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight(), 2 * jRPrintRectangle.getRadius(), 2 * jRPrintRectangle.getRadius());
            } else {
                this.grx.fillRect(jRPrintRectangle.getX() + this.getOffsetX(), jRPrintRectangle.getY() + this.getOffsetY(), jRPrintRectangle.getWidth(), jRPrintRectangle.getHeight());
            }
        }
        this.grx.setColor(jRPrintRectangle.getForecolor());
        byte by = jRPrintRectangle.getPen();
        Stroke stroke = JRGraphics2DExporter.getStroke(by);
        if (stroke != null) {
            double d = JRGraphics2DExporter.getBorderCornerOffset(by);
            int n = JRGraphics2DExporter.getRectangleSizeAdjust(by);
            AffineTransform affineTransform = this.grx.getTransform();
            this.grx.translate((double)(jRPrintRectangle.getX() + this.getOffsetX()) + d, (double)(jRPrintRectangle.getY() + this.getOffsetY()) + d);
            if (by == 5) {
                this.grx.scale(((double)jRPrintRectangle.getWidth() - 0.5) / (double)jRPrintRectangle.getWidth(), ((double)jRPrintRectangle.getHeight() - 0.5) / (double)jRPrintRectangle.getHeight());
            }
            this.grx.setStroke(stroke);
            if (jRPrintRectangle.getRadius() > 0) {
                this.grx.drawRoundRect(0, 0, jRPrintRectangle.getWidth() - n, jRPrintRectangle.getHeight() - n, 2 * jRPrintRectangle.getRadius(), 2 * jRPrintRectangle.getRadius());
            } else {
                this.grx.drawRect(0, 0, jRPrintRectangle.getWidth() - n, jRPrintRectangle.getHeight() - n);
            }
            this.grx.setTransform(affineTransform);
        }
    }

    private static int getRectangleSizeAdjust(byte by) {
        switch (by) {
            case 1: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    protected void exportEllipse(JRPrintEllipse jRPrintEllipse) {
        if (jRPrintEllipse.getMode() == 1) {
            this.grx.setColor(jRPrintEllipse.getBackcolor());
            this.grx.fillOval(jRPrintEllipse.getX() + this.getOffsetX(), jRPrintEllipse.getY() + this.getOffsetY(), jRPrintEllipse.getWidth(), jRPrintEllipse.getHeight());
        }
        this.grx.setColor(jRPrintEllipse.getForecolor());
        byte by = jRPrintEllipse.getPen();
        Stroke stroke = JRGraphics2DExporter.getStroke(by);
        if (stroke != null) {
            double d = JRGraphics2DExporter.getBorderCornerOffset(by);
            int n = JRGraphics2DExporter.getRectangleSizeAdjust(by);
            AffineTransform affineTransform = this.grx.getTransform();
            this.grx.translate((double)(jRPrintEllipse.getX() + this.getOffsetX()) + d, (double)(jRPrintEllipse.getY() + this.getOffsetY()) + d);
            if (by == 5) {
                this.grx.scale(((double)jRPrintEllipse.getWidth() - 0.5) / (double)jRPrintEllipse.getWidth(), ((double)jRPrintEllipse.getHeight() - 0.5) / (double)jRPrintEllipse.getHeight());
            }
            this.grx.setStroke(stroke);
            this.grx.drawOval(0, 0, jRPrintEllipse.getWidth() - n, jRPrintEllipse.getHeight() - n);
            this.grx.setTransform(affineTransform);
        }
    }

    protected void exportImage(JRPrintImage jRPrintImage) throws JRException {
        if (jRPrintImage.getMode() == 1) {
            this.grx.setColor(jRPrintImage.getBackcolor());
            this.grx.fillRect(jRPrintImage.getX() + this.getOffsetX(), jRPrintImage.getY() + this.getOffsetY(), jRPrintImage.getWidth(), jRPrintImage.getHeight());
        }
        int n = jRPrintImage.getTopPadding();
        int n2 = jRPrintImage.getLeftPadding();
        int n3 = jRPrintImage.getBottomPadding();
        int n4 = jRPrintImage.getRightPadding();
        int n5 = jRPrintImage.getWidth() - n2 - n4;
        n5 = n5 < 0 ? 0 : n5;
        int n6 = jRPrintImage.getHeight() - n - n3;
        n6 = n6 < 0 ? 0 : n6;
        JRRenderable jRRenderable = jRPrintImage.getRenderer();
        if (n5 > 0 && n6 > 0 && jRRenderable != null) {
            int n7 = n5;
            int n8 = n6;
            Dimension2D dimension2D = jRRenderable.getDimension();
            if (dimension2D != null) {
                n7 = (int)dimension2D.getWidth();
                n8 = (int)dimension2D.getHeight();
            }
            float f = 0.0f;
            switch (jRPrintImage.getHorizontalAlignment()) {
                case 3: {
                    f = 1.0f;
                    break;
                }
                case 2: {
                    f = 0.5f;
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            float f2 = 0.0f;
            switch (jRPrintImage.getVerticalAlignment()) {
                case 3: {
                    f2 = 1.0f;
                    break;
                }
                case 2: {
                    f2 = 0.5f;
                    break;
                }
                default: {
                    f2 = 0.0f;
                }
            }
            switch (jRPrintImage.getScaleImage()) {
                case 1: {
                    int n9 = (int)(f * (float)(n5 - n7));
                    int n10 = (int)(f2 * (float)(n6 - n8));
                    Shape shape = this.grx.getClip();
                    this.grx.clip(new Rectangle(jRPrintImage.getX() + n2 + this.getOffsetX(), jRPrintImage.getY() + n + this.getOffsetY(), n5, n6));
                    try {
                        jRRenderable.render(this.grx, new Rectangle(jRPrintImage.getX() + n2 + this.getOffsetX() + n9, jRPrintImage.getY() + n + this.getOffsetY() + n10, n7, n8));
                        break;
                    }
                    finally {
                        this.grx.setClip(shape);
                    }
                }
                case 2: {
                    jRRenderable.render(this.grx, new Rectangle(jRPrintImage.getX() + n2 + this.getOffsetX(), jRPrintImage.getY() + n + this.getOffsetY(), n5, n6));
                    break;
                }
                default: {
                    if (jRPrintImage.getHeight() <= 0) break;
                    double d = (double)n7 / (double)n8;
                    if (d > (double)n5 / (double)n6) {
                        n7 = n5;
                        n8 = (int)((double)n5 / d);
                    } else {
                        n7 = (int)((double)n6 * d);
                        n8 = n6;
                    }
                    int n11 = (int)(f * (float)(n5 - n7));
                    int n12 = (int)(f2 * (float)(n6 - n8));
                    jRRenderable.render(this.grx, new Rectangle(jRPrintImage.getX() + n2 + this.getOffsetX() + n11, jRPrintImage.getY() + n + this.getOffsetY() + n12, n7, n8));
                }
            }
        }
        if (jRPrintImage.getTopBorder() == 0 && jRPrintImage.getLeftBorder() == 0 && jRPrintImage.getBottomBorder() == 0 && jRPrintImage.getRightBorder() == 0) {
            if (jRPrintImage.getPen() != 0) {
                this.exportBox(this.getBox(jRPrintImage), jRPrintImage);
            }
        } else {
            this.exportBox(jRPrintImage, jRPrintImage);
        }
    }

    protected void exportText(JRPrintText jRPrintText) {
        JRStyledText jRStyledText = this.getStyledText(jRPrintText, false);
        if (jRStyledText == null) {
            return;
        }
        String string = jRStyledText.getText();
        int n = jRPrintText.getX() + this.getOffsetX();
        int n2 = jRPrintText.getY() + this.getOffsetY();
        int n3 = jRPrintText.getWidth();
        int n4 = jRPrintText.getHeight();
        int n5 = jRPrintText.getTopPadding();
        int n6 = jRPrintText.getLeftPadding();
        int n7 = jRPrintText.getBottomPadding();
        int n8 = jRPrintText.getRightPadding();
        double d = 0.0;
        switch (jRPrintText.getRotation()) {
            case 1: {
                n2 = jRPrintText.getY() + this.getOffsetY() + jRPrintText.getHeight();
                n3 = jRPrintText.getHeight();
                n4 = jRPrintText.getWidth();
                int n9 = n5;
                n5 = n6;
                n6 = n7;
                n7 = n8;
                n8 = n9;
                d = -1.5707963267948966;
                break;
            }
            case 2: {
                n = jRPrintText.getX() + this.getOffsetX() + jRPrintText.getWidth();
                n3 = jRPrintText.getHeight();
                n4 = jRPrintText.getWidth();
                int n10 = n5;
                n5 = n8;
                n8 = n7;
                n7 = n6;
                n6 = n10;
                d = 1.5707963267948966;
                break;
            }
            case 3: {
                int n11 = n5;
                n = jRPrintText.getX() + this.getOffsetX() + jRPrintText.getWidth();
                n2 = jRPrintText.getY() + this.getOffsetY() + jRPrintText.getHeight();
                n5 = n7;
                n7 = n11;
                n11 = n6;
                n6 = n8;
                n8 = n11;
                d = Math.PI;
            }
        }
        this.grx.rotate(d, n, n2);
        if (jRPrintText.getMode() == 1) {
            this.grx.setColor(jRPrintText.getBackcolor());
            this.grx.fillRect(n, n2, n3, n4);
        }
        if (string.length() > 0) {
            this.grx.setColor(jRPrintText.getForecolor());
            this.textRenderer.render(this.grx, n, n2, n3, n4, n5, n6, n7, n8, jRPrintText.getTextHeight(), jRPrintText.getHorizontalAlignment(), jRPrintText.getVerticalAlignment(), jRPrintText.getLineSpacingFactor(), jRPrintText.getLeadingOffset(), jRPrintText.getFontSize(), jRPrintText.isStyledText(), jRStyledText, string);
        }
        this.grx.rotate(-d, n, n2);
        this.exportBox(jRPrintText, jRPrintText);
    }

    protected void exportBox(JRBox jRBox, JRPrintElement jRPrintElement) {
        double d;
        Stroke stroke = null;
        Stroke stroke2 = null;
        Stroke stroke3 = null;
        Stroke stroke4 = null;
        if (jRBox != null) {
            stroke = JRGraphics2DExporter.getBorderStroke(jRBox.getTopBorder());
            stroke2 = JRGraphics2DExporter.getBorderStroke(jRBox.getLeftBorder());
            stroke3 = JRGraphics2DExporter.getBorderStroke(jRBox.getBottomBorder());
            stroke4 = JRGraphics2DExporter.getBorderStroke(jRBox.getRightBorder());
        }
        if (stroke != null) {
            d = JRGraphics2DExporter.getBorderCornerOffset(jRBox.getTopBorder());
            this.grx.setStroke(stroke);
            this.grx.setColor(jRBox.getTopBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getTopBorderColor());
            this.grx.translate(0.0, d);
            this.grx.drawLine(jRPrintElement.getX() + this.getOffsetX(), jRPrintElement.getY() + this.getOffsetY(), jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth(), jRPrintElement.getY() + this.getOffsetY());
            this.grx.translate(0.0, -d);
        }
        if (stroke2 != null) {
            d = JRGraphics2DExporter.getBorderCornerOffset(jRBox.getLeftBorder());
            this.grx.setStroke(stroke2);
            this.grx.setColor(jRBox.getLeftBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getLeftBorderColor());
            this.grx.translate(d, 0.0);
            this.grx.drawLine(jRPrintElement.getX() + this.getOffsetX(), jRPrintElement.getY() + this.getOffsetY(), jRPrintElement.getX() + this.getOffsetX(), jRPrintElement.getY() + this.getOffsetY() + jRPrintElement.getHeight());
            this.grx.translate(-d, 0.0);
        }
        if (stroke3 != null) {
            d = JRGraphics2DExporter.getBorderCornerOffset(jRBox.getBottomBorder());
            this.grx.setStroke(stroke3);
            this.grx.setColor(jRBox.getBottomBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getBottomBorderColor());
            this.grx.translate(0.0, -d);
            this.grx.drawLine(jRPrintElement.getX() + this.getOffsetX(), jRPrintElement.getY() + this.getOffsetY() + jRPrintElement.getHeight(), jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth(), jRPrintElement.getY() + this.getOffsetY() + jRPrintElement.getHeight());
            this.grx.translate(0.0, d);
        }
        if (stroke4 != null) {
            d = JRGraphics2DExporter.getBorderCornerOffset(jRBox.getRightBorder());
            this.grx.setStroke(stroke4);
            this.grx.setColor(jRBox.getRightBorderColor() == null ? jRPrintElement.getForecolor() : jRBox.getRightBorderColor());
            this.grx.translate(-d, 0.0);
            this.grx.drawLine(jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth(), jRPrintElement.getY() + this.getOffsetY(), jRPrintElement.getX() + this.getOffsetX() + jRPrintElement.getWidth(), jRPrintElement.getY() + this.getOffsetY() + jRPrintElement.getHeight());
            this.grx.translate(d, 0.0);
        }
    }

    private static Stroke getStroke(byte by) {
        switch (by) {
            case 4: {
                return STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return STROKE_THIN;
            }
        }
        return STROKE_1_POINT;
    }

    private static Stroke getBorderStroke(byte by) {
        switch (by) {
            case 4: {
                return BORDER_STROKE_DOTTED;
            }
            case 3: {
                return STROKE_4_POINT;
            }
            case 2: {
                return STROKE_2_POINT;
            }
            case 0: {
                return null;
            }
            case 5: {
                return BORDER_STROKE_THIN;
            }
        }
        return BORDER_STROKE_1_POINT;
    }

    private static double getBorderCornerOffset(byte by) {
        switch (by) {
            case 5: {
                return 0.25;
            }
            case 1: 
            case 4: {
                return 0.5;
            }
        }
        return 0.0;
    }

    protected void exportFrame(JRPrintFrame jRPrintFrame) throws JRException {
        if (jRPrintFrame.getMode() == 1) {
            int n = jRPrintFrame.getX() + this.getOffsetX();
            int n2 = jRPrintFrame.getY() + this.getOffsetY();
            this.grx.setColor(jRPrintFrame.getBackcolor());
            this.grx.fillRect(n, n2, jRPrintFrame.getWidth(), jRPrintFrame.getHeight());
        }
        this.setFrameElementsOffset(jRPrintFrame, false);
        try {
            this.exportElements(jRPrintFrame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(jRPrintFrame, jRPrintFrame);
    }
}

