/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCrosstab;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementGroup;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillFrame;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreport;
import net.sf.jasperreports.engine.fill.JRYComparator;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRFillElementContainer
extends JRFillElementGroup {
    protected JRBaseFiller filler;
    private JRFillElement[] ySortedElements = null;
    private JRFillElement[] stretchElements = null;
    private JRFillElement[] bandBottomElements = null;
    private JRFillElement[] removableElements = null;
    private boolean willOverflow = false;
    protected boolean isOverflow = false;
    private int stretchHeight = 0;
    private int firstY = 0;
    private boolean isFirstYFound = false;
    protected final JRFillExpressionEvaluator expressionEvaluator;
    protected JRFillElement[] deepElements;
    protected Set stylesToEvaluate = new HashSet();
    protected Map evaluatedStyles = new HashMap();
    protected boolean hasPrintWhenOverflowElement;

    protected JRFillElementContainer(JRBaseFiller jRBaseFiller, JRElementGroup jRElementGroup, JRFillObjectFactory jRFillObjectFactory) {
        super(jRElementGroup, jRFillObjectFactory);
        this.expressionEvaluator = jRFillObjectFactory.getExpressionEvaluator();
        this.initDeepElements();
        this.filler = jRBaseFiller;
    }

    protected JRFillElementContainer(JRFillElementContainer jRFillElementContainer, JRFillCloneFactory jRFillCloneFactory) {
        super(jRFillElementContainer, jRFillCloneFactory);
        this.expressionEvaluator = jRFillElementContainer.expressionEvaluator;
        this.initDeepElements();
        this.filler = jRFillElementContainer.filler;
    }

    private void initDeepElements() {
        if (this.elements == null) {
            this.deepElements = new JRFillElement[0];
        } else {
            ArrayList arrayList = new ArrayList(this.elements.length);
            JRFillElementContainer.collectDeepElements(this.elements, arrayList);
            this.deepElements = new JRFillElement[arrayList.size()];
            arrayList.toArray(this.deepElements);
        }
    }

    private static void collectDeepElements(JRElement[] jRElementArray, List list) {
        int n = 0;
        while (n < jRElementArray.length) {
            JRElement jRElement = jRElementArray[n];
            list.add(jRElement);
            if (jRElement instanceof JRFillFrame) {
                JRFrame jRFrame = (JRFrame)jRElement;
                JRFillElementContainer.collectDeepElements(jRFrame.getElements(), list);
            }
            ++n;
        }
    }

    protected final void initElements() {
        this.hasPrintWhenOverflowElement = false;
        if (this.elements != null && this.elements.length > 0) {
            ArrayList<JRFillElement> arrayList = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList2 = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList3 = new ArrayList<JRFillElement>();
            ArrayList<JRFillElement> arrayList4 = new ArrayList<JRFillElement>();
            int n = 0;
            while (n < this.elements.length) {
                JRFillElement jRFillElement = this.elements[n];
                arrayList.add(jRFillElement);
                if (jRFillElement.getPositionType() == 3) {
                    arrayList3.add(jRFillElement);
                }
                if (jRFillElement.getStretchType() != 0) {
                    arrayList2.add(jRFillElement);
                }
                if (jRFillElement.isRemoveLineWhenBlank()) {
                    arrayList4.add(jRFillElement);
                }
                if (jRFillElement.isPrintWhenDetailOverflows()) {
                    this.hasPrintWhenOverflowElement = true;
                }
                ++n;
            }
            Collections.sort(arrayList, new JRYComparator());
            this.ySortedElements = new JRFillElement[this.elements.length];
            arrayList.toArray(this.ySortedElements);
            this.stretchElements = new JRFillElement[arrayList2.size()];
            arrayList2.toArray(this.stretchElements);
            this.bandBottomElements = new JRFillElement[arrayList3.size()];
            arrayList3.toArray(this.bandBottomElements);
            this.removableElements = new JRFillElement[arrayList4.size()];
            arrayList4.toArray(this.removableElements);
        }
        this.setDependentElements();
        this.setElementsBandBottomY();
    }

    protected final void setElementsBandBottomY() {
        if (this.elements != null && this.elements.length > 0) {
            int n = 0;
            while (n < this.elements.length) {
                this.elements[n].setBandBottomY(this.getContainerHeight() - this.elements[n].getY() - this.elements[n].getHeight());
                ++n;
            }
        }
    }

    private void setDependentElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            JRFillElement jRFillElement = null;
            JRFillElement jRFillElement2 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.ySortedElements.length - 1) {
                jRFillElement = this.ySortedElements[n3];
                int n4 = n3 + 1;
                while (n4 < this.ySortedElements.length) {
                    jRFillElement2 = this.ySortedElements[n4];
                    n = Math.min(jRFillElement.getX(), jRFillElement2.getX());
                    n2 = Math.max(jRFillElement.getX() + jRFillElement.getWidth(), jRFillElement2.getX() + jRFillElement2.getWidth());
                    if (jRFillElement2.getPositionType() == 1 && jRFillElement.getY() + jRFillElement.getHeight() <= jRFillElement2.getY() && jRFillElement.getWidth() + jRFillElement2.getWidth() > n2 - n) {
                        jRFillElement.addDependantElement(jRFillElement2);
                    }
                    ++n4;
                }
                ++n3;
            }
        }
    }

    protected void evaluate(byte by) throws JRException {
        JRElement[] jRElementArray = this.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            int n = 0;
            while (n < jRElementArray.length) {
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[n];
                jRFillElement.setCurrentEvaluation(by);
                jRFillElement.evaluate(by);
                ++n;
            }
        }
    }

    protected void resetElements() {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            int n = 0;
            while (n < this.ySortedElements.length) {
                JRFillElement jRFillElement = this.ySortedElements[n];
                jRFillElement.reset();
                if (!this.isOverflow) {
                    jRFillElement.setAlreadyPrinted(false);
                }
                ++n;
            }
        }
    }

    protected boolean willOverflow() {
        return this.willOverflow;
    }

    protected void initFill() {
        this.isOverflow = this.willOverflow;
        this.firstY = 0;
        this.isFirstYFound = false;
    }

    protected void prepareElements(int n, boolean bl) throws JRException {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.firstY = this.isOverflow ? this.getContainerHeight() : 0;
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            int n5 = 0;
            while (n5 < this.ySortedElements.length) {
                JRFillElement jRFillElement = this.ySortedElements[n5];
                int n6 = this.getElementFirstY(jRFillElement);
                bl2 = jRFillElement.prepare(n + n6, this.isOverflow) || bl2;
                jRFillElement.moveDependantElements();
                if (jRFillElement.isToPrint()) {
                    if (this.isOverflow) {
                        if (jRFillElement.isReprinted()) {
                            this.firstY = 0;
                        } else if (!this.isFirstYFound) {
                            this.firstY = jRFillElement.getY();
                        }
                        this.isFirstYFound = true;
                    }
                    if ((n3 = jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() - this.getContainerHeight() + jRFillElement.getBandBottomY()) > n2) {
                        n2 = n3;
                    }
                }
                ++n5;
            }
        }
        if (n2 > n + this.firstY) {
            bl2 = true;
        }
        this.stretchHeight = bl2 ? this.getContainerHeight() + n : this.getContainerHeight() + n2;
        this.willOverflow = bl2 && bl;
    }

    private int getElementFirstY(JRFillElement jRFillElement) {
        int n = !this.isOverflow || this.hasPrintWhenOverflowElement ? 0 : (jRFillElement.getY() >= this.firstY ? this.firstY : jRFillElement.getY());
        return n;
    }

    protected void setStretchHeight(int n) {
        if (n > this.stretchHeight) {
            this.stretchHeight = n;
        }
    }

    protected void stretchElements() {
        JRFillElement jRFillElement;
        int n;
        if (this.stretchElements != null && this.stretchElements.length > 0) {
            n = 0;
            while (n < this.stretchElements.length) {
                jRFillElement = this.stretchElements[n];
                jRFillElement.stretchElement(this.stretchHeight - this.getContainerHeight());
                jRFillElement.moveDependantElements();
                ++n;
            }
        }
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            n = 0;
            while (n < this.ySortedElements.length) {
                jRFillElement = this.ySortedElements[n];
                jRFillElement.stretchHeightFinal();
                ++n;
            }
        }
    }

    protected int getStretchHeight() {
        return this.stretchHeight;
    }

    protected void moveBandBottomElements() {
        if (this.bandBottomElements != null && this.bandBottomElements.length > 0) {
            int n = 0;
            while (n < this.bandBottomElements.length) {
                JRFillElement jRFillElement = this.bandBottomElements[n];
                jRFillElement.setRelativeY(jRFillElement.getY() + this.stretchHeight - this.getContainerHeight());
                jRFillElement.setToPrint(jRFillElement.isToPrint() && !this.willOverflow);
                ++n;
            }
        }
    }

    protected void removeBlankElements() {
        JRFillElement[] jRFillElementArray = this.removableElements;
        if (jRFillElementArray != null && jRFillElementArray.length > 0) {
            JRFillElement[] jRFillElementArray2 = this.ySortedElements;
            int n = 0;
            while (n < jRFillElementArray.length) {
                JRFillElement jRFillElement = jRFillElementArray[n];
                int n2 = jRFillElement.isToPrint() ? jRFillElement.getHeight() - jRFillElement.getStretchHeight() : jRFillElement.getHeight();
                if (n2 > 0 && jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() <= this.stretchHeight && jRFillElement.getRelativeY() >= this.firstY) {
                    JRFillElement jRFillElement2;
                    int n3 = jRFillElement.getRelativeY() + jRFillElement.getHeight() - n2;
                    boolean bl = true;
                    int n4 = 0;
                    while (n4 < jRFillElementArray2.length) {
                        jRFillElement2 = jRFillElementArray2[n4];
                        if (jRFillElement != jRFillElement2 && jRFillElement2.isToPrint()) {
                            int n5 = Math.min(n3, jRFillElement2.getRelativeY());
                            int n6 = Math.max(n3 + n2, jRFillElement2.getRelativeY() + jRFillElement2.getStretchHeight());
                            if (n2 + jRFillElement2.getStretchHeight() > n6 - n5) {
                                bl = false;
                                break;
                            }
                        }
                        ++n4;
                    }
                    if (bl) {
                        n4 = 0;
                        while (n4 < jRFillElementArray2.length) {
                            jRFillElement2 = jRFillElementArray2[n4];
                            if (jRFillElement2.getRelativeY() >= n3 + n2) {
                                jRFillElement2.setRelativeY(jRFillElement2.getRelativeY() - n2);
                            }
                            ++n4;
                        }
                        this.stretchHeight -= n2;
                    }
                }
                ++n;
            }
        }
    }

    protected void fillElements(JRPrintElementContainer jRPrintElementContainer) throws JRException {
        JRElement[] jRElementArray = this.getElements();
        if (jRElementArray != null && jRElementArray.length > 0) {
            int n = 0;
            while (n < jRElementArray.length) {
                JRPrintElement jRPrintElement;
                JRFillElement jRFillElement = (JRFillElement)jRElementArray[n];
                jRFillElement.setRelativeY(jRFillElement.getRelativeY() - this.firstY);
                if (jRFillElement.getRelativeY() + jRFillElement.getStretchHeight() > this.stretchHeight) {
                    jRFillElement.setToPrint(false);
                }
                jRFillElement.setAlreadyPrinted(jRFillElement.isToPrint() || jRFillElement.isAlreadyPrinted());
                if (jRFillElement.isToPrint() && (jRPrintElement = jRFillElement.fill()) != null) {
                    Object object;
                    jRPrintElementContainer.addElement(jRPrintElement);
                    if (jRFillElement instanceof JRFillSubreport) {
                        List list;
                        object = (JRFillSubreport)jRFillElement;
                        List list2 = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getFontsList();
                        if (list2 != null) {
                            int n2 = 0;
                            while (n2 < list2.size()) {
                                this.filler.getJasperPrint().addFont((JRReportFont)list2.get(n2), true);
                                ++n2;
                            }
                        }
                        if ((list = ((JRFillSubreport)object).subreportFiller.getJasperPrint().getStylesList()) != null) {
                            int n3 = 0;
                            while (n3 < list.size()) {
                                this.filler.getJasperPrint().addStyle((JRStyle)list.get(n3), true);
                                ++n3;
                            }
                        }
                        Collection collection = ((JRFillSubreport)object).getPrintElements();
                        this.addSubElements(jRPrintElementContainer, jRFillElement, collection);
                    } else if (jRFillElement instanceof JRFillCrosstab) {
                        object = ((JRFillCrosstab)jRFillElement).getPrintElements();
                        this.addSubElements(jRPrintElementContainer, jRFillElement, (Collection)object);
                    }
                }
                ++n;
            }
        }
        jRPrintElementContainer.setHeight(this.stretchHeight - this.firstY);
    }

    protected void addSubElements(JRPrintElementContainer jRPrintElementContainer, JRFillElement jRFillElement, Collection collection) {
        if (collection != null && collection.size() > 0) {
            for (JRPrintElement jRPrintElement : collection) {
                jRPrintElement.setX(jRFillElement.getX() + jRPrintElement.getX());
                jRPrintElement.setY(jRFillElement.getRelativeY() + jRPrintElement.getY());
                jRPrintElementContainer.addElement(jRPrintElement);
            }
        }
    }

    protected void rewind() throws JRException {
        if (this.ySortedElements != null && this.ySortedElements.length > 0) {
            int n = 0;
            while (n < this.ySortedElements.length) {
                JRFillElement jRFillElement = this.ySortedElements[n];
                jRFillElement.rewind();
                jRFillElement.setAlreadyPrinted(false);
                ++n;
            }
        }
        this.willOverflow = false;
    }

    protected int getFirstY() {
        return this.firstY;
    }

    protected abstract int getContainerHeight();

    protected void initConditionalStyles() {
        this.collectConditionalStyle(this.filler.getDefaultStyle());
        int n = 0;
        while (n < this.deepElements.length) {
            JRStyle jRStyle = this.deepElements[n].initStyle;
            this.collectConditionalStyle(jRStyle);
            ++n;
        }
        if (this.deepElements.length > 0) {
            n = 0;
            while (n < this.deepElements.length) {
                this.deepElements[n].setConditionalStylesContainer(this);
                ++n;
            }
        }
    }

    protected void collectConditionalStyle(JRStyle jRStyle) {
        if (jRStyle != null) {
            this.stylesToEvaluate.add(jRStyle);
        }
    }

    protected void evaluateConditionalStyles(byte by) throws JRException {
        Iterator iterator = this.stylesToEvaluate.iterator();
        while (iterator.hasNext()) {
            this.evaluateConditionalStyle((JRStyle)iterator.next(), by);
        }
    }

    protected JRStyle evaluateConditionalStyle(JRStyle jRStyle, byte by) throws JRException {
        JRStyle jRStyle2 = jRStyle;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        boolean bl = this.buildConsolidatedStyle(jRStyle, by, stringBuffer, arrayList);
        if (bl) {
            String string = String.valueOf(jRStyle.getName()) + stringBuffer.toString();
            jRStyle2 = (JRStyle)this.filler.getJasperPrint().getStylesMap().get(string);
            if (jRStyle2 == null) {
                jRStyle2 = new JRBaseStyle(string);
                int n = arrayList.size() - 1;
                while (n >= 0) {
                    JRStyleResolver.appendStyle(jRStyle2, (JRStyle)arrayList.get(n));
                    --n;
                }
                this.filler.getJasperPrint().addStyle(jRStyle2, true);
            }
        }
        this.evaluatedStyles.put(jRStyle, jRStyle2);
        return jRStyle2;
    }

    protected boolean buildConsolidatedStyle(JRStyle jRStyle, byte by, StringBuffer stringBuffer, List list) throws JRException {
        boolean bl = false;
        JRConditionalStyle[] jRConditionalStyleArray = jRStyle.getConditionalStyles();
        if (jRConditionalStyleArray != null && jRConditionalStyleArray.length > 0) {
            int n = 0;
            while (n < jRConditionalStyleArray.length) {
                JRConditionalStyle jRConditionalStyle = jRConditionalStyleArray[n];
                Boolean bl2 = (Boolean)this.expressionEvaluator.evaluate(jRConditionalStyle.getConditionExpression(), by);
                boolean bl3 = bl2 == null ? false : bl2;
                stringBuffer.append(bl3 ? (char)'1' : '0');
                bl |= bl3;
                if (bl3) {
                    list.add(jRConditionalStyle);
                }
                ++n;
            }
        }
        list.add(jRStyle);
        if (jRStyle.getStyle() != null) {
            bl |= this.buildConsolidatedStyle(jRStyle.getStyle(), by, stringBuffer, list);
        }
        return bl;
    }

    public JRStyle getEvaluatedConditionalStyle(JRStyle jRStyle) {
        return (JRStyle)this.evaluatedStyles.get(jRStyle);
    }
}

