/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrame;
import org.eclipse.jdt.internal.compiler.codegen.StackMapFrameCodeStream;
import org.eclipse.jdt.internal.compiler.codegen.VerificationTypeInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.util.Messages;

public class ClassFile
implements TypeConstants,
TypeIds {
    private byte[] bytes;
    public CodeStream codeStream;
    public ConstantPool constantPool;
    public int constantPoolOffset;
    public byte[] contents;
    public int contentsOffset;
    protected boolean creatingProblemType;
    public ClassFile enclosingClassFile;
    public byte[] header;
    public int headerOffset;
    public ReferenceBinding[] innerClassesBindings;
    public int methodCount;
    public int methodCountOffset;
    public int numberOfInnerClasses;
    public boolean isShared = false;
    public int produceAttributes;
    public SourceTypeBinding referenceBinding;
    public long targetJDK;
    public static final int INITIAL_CONTENTS_SIZE = 400;
    public static final int INITIAL_HEADER_SIZE = 1500;
    public static final int INNER_CLASSES_SIZE = 5;

    public static String buildAllDirectoriesInto(String string, String string2) throws IOException {
        String string3;
        String string4;
        char c = File.separatorChar;
        String string5 = File.separator;
        string = string.replace('/', c);
        int n = (string2 = string2.replace('/', c)).lastIndexOf(c);
        if (n == -1) {
            if (string.endsWith(string5)) {
                string4 = string.substring(0, string.length() - 1);
                string3 = String.valueOf(string) + string2;
            } else {
                string4 = string;
                string3 = String.valueOf(string) + string5 + string2;
            }
        } else if (string.endsWith(string5)) {
            string4 = String.valueOf(string) + string2.substring(0, n);
            string3 = String.valueOf(string) + string2;
        } else {
            string4 = String.valueOf(string) + string5 + string2.substring(0, n);
            string3 = String.valueOf(string) + string5 + string2;
        }
        File file = new File(string4);
        file.mkdirs();
        if (file.isDirectory()) {
            return string3;
        }
        if (string.endsWith(string5)) {
            string = string.substring(0, string.length() - 1);
        }
        file = new File(string);
        boolean bl = false;
        if (file.exists()) {
            bl = true;
        } else if (!file.mkdirs()) {
            if (file.exists()) {
                bl = true;
            } else {
                throw new IOException(Messages.bind(Messages.output_notValidAll, file.getAbsolutePath()));
            }
        }
        if (bl && !file.isDirectory()) {
            throw new IOException(Messages.bind(Messages.output_isFile, file.getAbsolutePath()));
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string5);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string5);
        String string6 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            file = new File(stringBuffer.append(string6).append(string5).toString());
            bl = false;
            if (file.exists()) {
                bl = true;
            } else if (!file.mkdir()) {
                if (file.exists()) {
                    bl = true;
                } else {
                    throw new IOException(Messages.bind(Messages.output_notValid, stringBuffer.substring(string.length() + 1, stringBuffer.length() - 1), string));
                }
            }
            if (bl && !file.isDirectory()) {
                throw new IOException(Messages.bind(Messages.output_isFile, file.getAbsolutePath()));
            }
            string6 = stringTokenizer.nextToken();
        }
        return stringBuffer.append(string6).toString();
    }

    public static void createProblemType(TypeDeclaration typeDeclaration, CompilationResult compilationResult) {
        ASTNode aSTNode;
        int n;
        int n2;
        FieldBinding[] fieldBindingArray;
        SourceTypeBinding sourceTypeBinding = typeDeclaration.binding;
        ClassFile classFile = ClassFile.getNewInstance(sourceTypeBinding);
        classFile.initialize(sourceTypeBinding, null, true);
        if (sourceTypeBinding.isMemberType()) {
            classFile.recordEnclosingTypeAttributes(sourceTypeBinding);
        }
        if ((fieldBindingArray = sourceTypeBinding.fields()) != null && fieldBindingArray != Binding.NO_FIELDS) {
            classFile.addFieldInfos();
        } else {
            classFile.contents[classFile.contentsOffset++] = 0;
            classFile.contents[classFile.contentsOffset++] = 0;
        }
        classFile.setForMethodInfos();
        CategorizedProblem[] categorizedProblemArray = compilationResult.getErrors();
        if (categorizedProblemArray == null) {
            categorizedProblemArray = new CategorizedProblem[]{};
        }
        int n3 = categorizedProblemArray.length;
        CategorizedProblem[] categorizedProblemArray2 = new CategorizedProblem[n3];
        System.arraycopy(categorizedProblemArray, 0, categorizedProblemArray2, 0, n3);
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = typeDeclaration.methods;
        if (abstractMethodDeclarationArray != null) {
            MethodBinding methodBinding;
            if (sourceTypeBinding.isInterface()) {
                classFile.addProblemClinit(categorizedProblemArray2);
                n2 = 0;
                n = abstractMethodDeclarationArray.length;
                while (n2 < n) {
                    aSTNode = abstractMethodDeclarationArray[n2];
                    methodBinding = aSTNode.binding;
                    if (methodBinding != null && !methodBinding.isConstructor()) {
                        classFile.addAbstractMethod((AbstractMethodDeclaration)aSTNode, methodBinding);
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                n = abstractMethodDeclarationArray.length;
                while (n2 < n) {
                    aSTNode = abstractMethodDeclarationArray[n2];
                    methodBinding = aSTNode.binding;
                    if (methodBinding != null) {
                        if (methodBinding.isConstructor()) {
                            classFile.addProblemConstructor((AbstractMethodDeclaration)aSTNode, methodBinding, categorizedProblemArray2);
                        } else {
                            classFile.addProblemMethod((AbstractMethodDeclaration)aSTNode, methodBinding, categorizedProblemArray2);
                        }
                    }
                    ++n2;
                }
            }
            classFile.addDefaultAbstractMethods();
        }
        if (typeDeclaration.memberTypes != null) {
            n2 = 0;
            n = typeDeclaration.memberTypes.length;
            while (n2 < n) {
                aSTNode = typeDeclaration.memberTypes[n2];
                if (((TypeDeclaration)aSTNode).binding != null) {
                    classFile.recordNestedMemberAttribute(((TypeDeclaration)aSTNode).binding);
                    ClassFile.createProblemType((TypeDeclaration)aSTNode, compilationResult);
                }
                ++n2;
            }
        }
        classFile.addAttributes();
        compilationResult.record(sourceTypeBinding.constantPoolName(), classFile);
    }

    public static ClassFile getNewInstance(SourceTypeBinding sourceTypeBinding) {
        LookupEnvironment lookupEnvironment = sourceTypeBinding.scope.environment();
        return lookupEnvironment.classFilePool.acquire(sourceTypeBinding);
    }

    public static final int searchLineNumber(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n2 == 0) {
            return 1;
        }
        int n3 = 0;
        int n4 = n2 - 1;
        int n5 = 0;
        while (n3 <= n4) {
            n5 = (n3 + n4) / 2;
            int n6 = nArray[n5];
            if (n < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n > n6) {
                n3 = n5 + 1;
                continue;
            }
            return n5 + 1;
        }
        if (n < nArray[n5]) {
            return n5 + 1;
        }
        return n5 + 2;
    }

    public static void writeToDisk(boolean bl, String string, String string2, ClassFile classFile) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        if (bl) {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(ClassFile.buildAllDirectoriesInto(string, string2))));
        } else {
            String string3 = null;
            char c = File.separatorChar;
            String string4 = File.separator;
            string = string.replace('/', c);
            int n = string2.lastIndexOf(c);
            if (n == -1) {
                string3 = string.endsWith(string4) ? String.valueOf(string) + string2 : String.valueOf(string) + string4 + string2;
            } else {
                int n2 = string2.length();
                string3 = string.endsWith(string4) ? String.valueOf(string) + string2.substring(n + 1, n2) : String.valueOf(string) + string4 + string2.substring(n + 1, n2);
            }
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string3)));
        }
        try {
            bufferedOutputStream.write(classFile.header, 0, classFile.headerOffset);
            bufferedOutputStream.write(classFile.contents, 0, classFile.contentsOffset);
        }
        finally {
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
    }

    protected ClassFile() {
    }

    public ClassFile(SourceTypeBinding sourceTypeBinding) {
        this.constantPool = new ConstantPool(this);
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        this.referenceBinding = sourceTypeBinding;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
            this.codeStream = new StackMapFrameCodeStream(this);
        } else {
            this.codeStream = new CodeStream(this);
        }
        this.initByteArrays();
    }

    public void addAbstractMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding) {
        methodBinding.modifiers = 1025;
        this.generateMethodInfoHeader(methodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        this.completeMethodInfo(n, n2);
    }

    public void addAttributes() {
        Annotation[] annotationArray;
        TypeDeclaration typeDeclaration;
        char[] cArray;
        int n;
        int n2;
        int n3;
        int n4;
        this.contents[this.methodCountOffset++] = (byte)(this.methodCount >> 8);
        this.contents[this.methodCountOffset] = (byte)this.methodCount;
        int n5 = 0;
        int n6 = this.contentsOffset;
        this.contentsOffset += 2;
        if ((this.produceAttributes & 1) != 0) {
            String string = new String(this.referenceBinding.scope.referenceCompilationUnit().getFileName());
            n4 = (string = string.replace('\\', '/')).lastIndexOf(47);
            if (n4 != -1) {
                string = string.substring(n4 + 1, string.length());
            }
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SourceName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n2 = this.constantPool.literalIndex(string.toCharArray());
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            ++n5;
        }
        if (this.referenceBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int n7 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
            this.contents[this.contentsOffset++] = (byte)n7;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (this.numberOfInnerClasses != 0) {
            int n8 = 8 * this.numberOfInnerClasses + 8;
            if (n8 + this.contentsOffset >= this.contents.length) {
                this.resizeContents(n8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.InnerClassName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            n3 = (this.numberOfInnerClasses << 3) + 2;
            this.contents[this.contentsOffset++] = (byte)(n3 >> 24);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 16);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = (byte)(this.numberOfInnerClasses >> 8);
            this.contents[this.contentsOffset++] = (byte)this.numberOfInnerClasses;
            n2 = 0;
            while (n2 < this.numberOfInnerClasses) {
                int n9;
                ReferenceBinding referenceBinding = this.innerClassesBindings[n2];
                int n10 = referenceBinding.getAccessFlags();
                n = this.constantPool.literalIndexForType(referenceBinding.constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(n >> 8);
                this.contents[this.contentsOffset++] = (byte)n;
                if (referenceBinding.isMemberType()) {
                    n9 = this.constantPool.literalIndexForType(referenceBinding.enclosingType().constantPoolName());
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (!referenceBinding.isAnonymousType()) {
                    n9 = this.constantPool.literalIndex(referenceBinding.sourceName());
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                } else {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                }
                if (referenceBinding.isAnonymousType()) {
                    n10 &= 0xFFFFFFEF;
                } else if (referenceBinding.isMemberType() && referenceBinding.isInterface()) {
                    n10 |= 8;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
                ++n2;
            }
            ++n5;
        }
        if ((cArray = this.referenceBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n3 = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && this.referenceBinding.isNestedType() && !this.referenceBinding.isMemberType()) {
            MethodBinding methodBinding;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.EnclosingMethodName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 4;
            n3 = this.constantPool.literalIndexForType(this.referenceBinding.enclosingType().constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            n2 = 0;
            byte by = 0;
            if (this.referenceBinding instanceof LocalTypeBinding && (methodBinding = ((LocalTypeBinding)this.referenceBinding).enclosingMethod) != null) {
                n = this.constantPool.literalIndexForNameAndType(methodBinding.selector, methodBinding.signature());
                n2 = (byte)(n >> 8);
                by = (byte)n;
            }
            this.contents[this.contentsOffset++] = n2;
            this.contents[this.contentsOffset++] = by;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (typeDeclaration = this.referenceBinding.scope.referenceContext) != null && (annotationArray = typeDeclaration.annotations) != null) {
            n5 += this.generateRuntimeAnnotations(annotationArray);
        }
        if (this.referenceBinding.isHierarchyInconsistent()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            int n11 = this.constantPool.literalIndex(AttributeNamesConstants.InconsistentHierarchy);
            this.contents[this.contentsOffset++] = (byte)(n11 >> 8);
            this.contents[this.contentsOffset++] = (byte)n11;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (n6 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n6++] = (byte)(n5 >> 8);
        this.contents[n6] = (byte)n5;
        this.header = this.constantPool.poolContent;
        this.headerOffset = this.constantPool.currentOffset;
        int n12 = this.constantPool.currentIndex;
        this.header[this.constantPoolOffset++] = (byte)(n12 >> 8);
        this.header[this.constantPoolOffset] = (byte)n12;
    }

    public void addDefaultAbstractMethods() {
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            this.generateMethodInfoHeader(methodBindingArray[n]);
            int n3 = this.contentsOffset;
            int n4 = this.generateMethodInfoAttribute(methodBindingArray[n]);
            this.completeMethodInfo(n3, n4);
            ++n;
        }
    }

    private int addFieldAttributes(FieldBinding fieldBinding, int n) {
        Annotation[] annotationArray;
        FieldDeclaration fieldDeclaration;
        char[] cArray;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        Constant constant = fieldBinding.constant();
        if (constant != Constant.NotAConstant) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.ConstantValueName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            ++n5;
            switch (constant.typeID()) {
                case 5: {
                    n3 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 10: {
                    n2 = this.constantPool.literalIndex(constant.intValue());
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    break;
                }
                case 9: {
                    int n6 = this.constantPool.literalIndex(constant.floatValue());
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                    break;
                }
                case 8: {
                    int n7 = this.constantPool.literalIndex(constant.doubleValue());
                    this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n7;
                    break;
                }
                case 7: {
                    int n8 = this.constantPool.literalIndex(constant.longValue());
                    this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n8;
                    break;
                }
                case 11: {
                    int n9 = this.constantPool.literalIndex(((StringConstant)constant).stringValue());
                    if (n9 == -1) {
                        if (!this.creatingProblemType) {
                            TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                            FieldDeclaration[] fieldDeclarationArray = typeDeclaration.fields;
                            int n10 = 0;
                            int n11 = fieldDeclarationArray.length;
                            while (n10 < n11) {
                                if (fieldDeclarationArray[n10].binding == fieldBinding) {
                                    typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(fieldDeclarationArray[n10]);
                                }
                                ++n10;
                            }
                            break;
                        }
                        this.contentsOffset = n;
                        break;
                    }
                    this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n9;
                }
            }
        }
        if (this.targetJDK < 0x310000L && fieldBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if (fieldBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n4 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
            this.contents[this.contentsOffset++] = (byte)n4;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n5;
        }
        if ((cArray = fieldBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n2 = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            ++n5;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && (fieldDeclaration = fieldBinding.sourceField()) != null && (annotationArray = fieldDeclaration.annotations) != null) {
            n5 += this.generateRuntimeAnnotations(annotationArray);
        }
        return n5;
    }

    private void addFieldInfo(FieldBinding fieldBinding) {
        if (this.contentsOffset + 8 >= this.contents.length) {
            this.resizeContents(8);
        }
        int n = fieldBinding.getAccessFlags();
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(fieldBinding.name);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(fieldBinding.type.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        int n4 = this.contentsOffset;
        int n5 = 0;
        this.contentsOffset += 2;
        n5 += this.addFieldAttributes(fieldBinding, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n4++] = (byte)(n5 >> 8);
        this.contents[n4] = (byte)n5;
    }

    public void addFieldInfos() {
        SourceTypeBinding sourceTypeBinding = this.referenceBinding;
        FieldBinding[] fieldBindingArray = sourceTypeBinding.syntheticFields();
        int n = sourceTypeBinding.fieldCount() + (fieldBindingArray == null ? 0 : fieldBindingArray.length);
        if (n > 65535) {
            this.referenceBinding.scope.problemReporter().tooManyFields(this.referenceBinding.scope.referenceType());
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        int n2 = 0;
        int n3 = fieldDeclarationArray == null ? 0 : fieldDeclarationArray.length;
        while (n2 < n3) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            if (fieldDeclaration.binding != null) {
                this.addFieldInfo(fieldDeclaration.binding);
            }
            ++n2;
        }
        if (fieldBindingArray != null) {
            n2 = 0;
            n3 = fieldBindingArray.length;
            while (n2 < n3) {
                this.addFieldInfo(fieldBindingArray[n2]);
                ++n2;
            }
        }
    }

    private void addInnerClasses(ReferenceBinding referenceBinding) {
        int n = 0;
        while (n < this.numberOfInnerClasses) {
            if (this.innerClassesBindings[n] == referenceBinding) {
                return;
            }
            ++n;
        }
        n = this.innerClassesBindings.length;
        if (this.numberOfInnerClasses == n) {
            this.innerClassesBindings = new ReferenceBinding[n * 2];
            System.arraycopy(this.innerClassesBindings, 0, this.innerClassesBindings, 0, n);
        }
        this.innerClassesBindings[this.numberOfInnerClasses++] = referenceBinding;
    }

    private void addMissingAbstractProblemMethod(MethodDeclaration methodDeclaration, MethodBinding methodBinding, CategorizedProblem categorizedProblem, CompilationResult compilationResult) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        StringBuffer stringBuffer = new StringBuffer(25);
        stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
        stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
        String string = stringBuffer.toString();
        this.codeStream.init(this);
        this.codeStream.preserveUnusedLocals = true;
        this.codeStream.initializeMaxLocals(methodBinding);
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForMissingAbstractProblemMethod(methodBinding, n3, compilationResult.getLineSeparatorPositions(), categorizedProblem.getSourceLineNumber());
        this.completeMethodInfo(n, n2);
    }

    public void addProblemClinit(CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeaderForClinit();
        this.contentsOffset -= 2;
        int n = this.contentsOffset;
        this.contentsOffset += 2;
        int n2 = 0;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.resetForProblemClinit(this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError()) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                    categorizedProblemArray[n7] = null;
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        ++n2;
        this.completeCodeAttributeForClinit(n3, n4);
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding, true);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError()) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(n, n2);
    }

    public void addProblemConstructor(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemConstructor(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray) {
        if (methodBinding.isAbstract() && methodBinding.declaringClass.isInterface()) {
            abstractMethodDeclaration.abort(8, null);
        }
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers & 0xFFFFF2FF);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(methodBinding, true);
        ++n2;
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.reset(abstractMethodDeclaration, this);
        String string = "";
        int n4 = 0;
        if (categorizedProblemArray != null) {
            int n5 = categorizedProblemArray.length;
            StringBuffer stringBuffer = new StringBuffer(25);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n5) {
                CategorizedProblem categorizedProblem = categorizedProblemArray[n7];
                if (categorizedProblem != null && categorizedProblem.isError() && categorizedProblem.getSourceStart() >= abstractMethodDeclaration.declarationSourceStart && categorizedProblem.getSourceEnd() <= abstractMethodDeclaration.declarationSourceEnd) {
                    stringBuffer.append("\t" + categorizedProblem.getMessage() + "\n");
                    ++n6;
                    if (n4 == 0) {
                        n4 = categorizedProblem.getSourceLineNumber();
                    }
                    categorizedProblemArray[n7] = null;
                }
                ++n7;
            }
            if (n6 > 1) {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblems);
            } else {
                stringBuffer.insert(0, Messages.compilation_unresolvedProblem);
            }
            string = stringBuffer.toString();
        }
        this.codeStream.generateCodeAttributeForProblemMethod(string);
        this.completeCodeAttributeForProblemMethod(abstractMethodDeclaration, methodBinding, n3, ((SourceTypeBinding)methodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions(), n4);
        this.completeMethodInfo(n, n2);
    }

    public void addProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, CategorizedProblem[] categorizedProblemArray, int n) {
        this.contentsOffset = n;
        --this.methodCount;
        this.addProblemMethod(abstractMethodDeclaration, methodBinding, categorizedProblemArray);
    }

    public void addSpecialMethods() {
        int n;
        this.generateMissingAbstractMethods(this.referenceBinding.scope.referenceType().missingAbstractMethods, this.referenceBinding.scope.referenceCompilationUnit().compilationResult);
        MethodBinding[] methodBindingArray = this.referenceBinding.getDefaultAbstractMethods();
        int n2 = 0;
        int n3 = methodBindingArray.length;
        while (n2 < n3) {
            this.generateMethodInfoHeader(methodBindingArray[n2]);
            n = this.contentsOffset;
            int n4 = this.generateMethodInfoAttribute(methodBindingArray[n2]);
            this.completeMethodInfo(n, n4);
            ++n2;
        }
        SyntheticMethodBinding[] syntheticMethodBindingArray = this.referenceBinding.syntheticMethods();
        if (syntheticMethodBindingArray != null) {
            n3 = 0;
            n = syntheticMethodBindingArray.length;
            while (n3 < n) {
                SyntheticMethodBinding syntheticMethodBinding = syntheticMethodBindingArray[n3];
                switch (syntheticMethodBinding.kind) {
                    case 1: {
                        this.addSyntheticFieldReadAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 2: {
                        this.addSyntheticFieldWriteAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 6: {
                        this.addSyntheticMethodAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 4: {
                        this.addSyntheticConstructorAccessMethod(syntheticMethodBinding);
                        break;
                    }
                    case 7: {
                        this.addSyntheticEnumValuesMethod(syntheticMethodBinding);
                        break;
                    }
                    case 8: {
                        this.addSyntheticEnumValueOfMethod(syntheticMethodBinding);
                        break;
                    }
                    case 9: {
                        this.addSyntheticSwitchTable(syntheticMethodBinding);
                    }
                }
                ++n3;
            }
        }
    }

    public void addSyntheticConstructorAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForConstructorAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValueOfMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValueOf(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticEnumValuesMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForEnumValues(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldReadAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldReadAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticFieldWriteAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForFieldWriteAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticMethodAccessMethod(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForMethodAccess(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void addSyntheticSwitchTable(SyntheticMethodBinding syntheticMethodBinding) {
        this.generateMethodInfoHeader(syntheticMethodBinding);
        int n = this.contentsOffset;
        int n2 = this.generateMethodInfoAttribute(syntheticMethodBinding);
        int n3 = this.contentsOffset;
        this.generateCodeAttributeHeader();
        this.codeStream.init(this);
        this.codeStream.generateSyntheticBodyForSwitchTable(syntheticMethodBinding);
        this.completeCodeAttributeForSyntheticMethod(true, syntheticMethodBinding, n3, ((SourceTypeBinding)syntheticMethodBinding.declaringClass).scope.referenceCompilationUnit().compilationResult.getLineSeparatorPositions());
        this.contents[n++] = (byte)(++n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public void completeCodeAttribute(int n) {
        Set set;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        Object object2;
        Object object3;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Object object4;
        this.contents = this.codeStream.bCodeStream;
        int n13 = this.codeStream.classFileOffset;
        int n14 = this.codeStream.position;
        if (n14 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration);
        }
        if (n13 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n15 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n15 >> 8);
        this.contents[n + 7] = (byte)n15;
        int n16 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n16 >> 8);
        this.contents[n + 9] = (byte)n16;
        this.contents[n + 10] = (byte)(n14 >> 24);
        this.contents[n + 11] = (byte)(n14 >> 16);
        this.contents[n + 12] = (byte)(n14 >> 8);
        this.contents[n + 13] = (byte)n14;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n17 = 0;
        int n18 = 0;
        int n19 = this.codeStream.exceptionLabelsCounter;
        while (n18 < n19) {
            n17 += this.codeStream.exceptionLabels[n18].count / 2;
            ++n18;
        }
        n18 = n17 * 8 + 2;
        if (n18 + n13 >= this.contents.length) {
            this.resizeContents(n18);
        }
        this.contents[n13++] = (byte)(n17 >> 8);
        this.contents[n13++] = (byte)n17;
        n19 = 0;
        int n20 = this.codeStream.exceptionLabelsCounter;
        while (n19 < n20) {
            object4 = exceptionLabelArray[n19];
            if (object4 != null) {
                n12 = 0;
                n11 = ((ExceptionLabel)object4).count;
                if ((n11 & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (n12 < n11) {
                    n10 = ((ExceptionLabel)object4).ranges[n12++];
                    this.contents[n13++] = (byte)(n10 >> 8);
                    this.contents[n13++] = (byte)n10;
                    n9 = ((ExceptionLabel)object4).ranges[n12++];
                    this.contents[n13++] = (byte)(n9 >> 8);
                    this.contents[n13++] = (byte)n9;
                    n8 = ((ExceptionLabel)object4).position;
                    this.contents[n13++] = (byte)(n8 >> 8);
                    this.contents[n13++] = (byte)n8;
                    if (((ExceptionLabel)object4).exceptionType == null) {
                        this.contents[n13++] = 0;
                        this.contents[n13++] = 0;
                        continue;
                    }
                    object3 = ((ExceptionLabel)object4).exceptionType == TypeBinding.NULL ? (Object)this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : (Object)this.constantPool.literalIndexForType(((ExceptionLabel)object4).exceptionType.constantPoolName());
                    this.contents[n13++] = (byte)(object3 >> 8);
                    this.contents[n13++] = (byte)object3;
                }
            }
            ++n19;
        }
        n19 = n13;
        n20 = 0;
        if ((n13 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            object4 = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                n12 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (n13 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n13++] = (byte)(n12 >> 8);
                this.contents[n13++] = (byte)n12;
                n11 = n13;
                n13 += 6;
                n10 = 0;
                n9 = this.codeStream.pcToSourceMapSize;
                n8 = 0;
                while (n8 < n9) {
                    if (n13 + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    object3 = object4[n8++];
                    this.contents[n13++] = (byte)(object3 >> 8);
                    this.contents[n13++] = (byte)object3;
                    object2 = object4[n8++];
                    this.contents[n13++] = (byte)(object2 >> 8);
                    this.contents[n13++] = (byte)object2;
                    ++n10;
                }
                n8 = n10 * 4 + 2;
                this.contents[n11++] = (byte)(n8 >> 24);
                this.contents[n11++] = (byte)(n8 >> 16);
                this.contents[n11++] = (byte)(n8 >> 8);
                this.contents[n11++] = (byte)n8;
                this.contents[n11++] = (byte)(n10 >> 8);
                this.contents[n11++] = (byte)n10;
                ++n20;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int n21;
            int n22;
            int n23 = 0;
            n12 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            n11 = this.codeStream.methodDeclaration.isStatic() ? 1 : 0;
            n10 = 8 + 10 * (n11 != 0 ? 0 : 1);
            n9 = 0;
            while (n9 < this.codeStream.allLocalsCounter) {
                n10 += 10 * this.codeStream.locals[n9].initializationCount;
                ++n9;
            }
            if (n13 + n10 >= this.contents.length) {
                this.resizeContents(n10);
            }
            this.contents[n13++] = (byte)(n12 >> 8);
            this.contents[n13++] = (byte)n12;
            n9 = n13;
            n13 += 6;
            SourceTypeBinding sourceTypeBinding = null;
            if (n11 == 0) {
                ++n23;
                this.contents[n13++] = 0;
                this.contents[n13++] = 0;
                this.contents[n13++] = (byte)(n14 >> 8);
                this.contents[n13++] = (byte)n14;
                n8 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n13++] = (byte)(n8 >> 8);
                this.contents[n13++] = (byte)n8;
                sourceTypeBinding = (SourceTypeBinding)this.codeStream.methodDeclaration.binding.declaringClass;
                object3 = this.constantPool.literalIndex(sourceTypeBinding.signature());
                this.contents[n13++] = (byte)(object3 >> 8);
                this.contents[n13++] = (byte)object3;
                this.contents[n13++] = 0;
                this.contents[n13++] = 0;
            }
            int n24 = 0;
            object = null;
            int n25 = 0;
            n7 = 0;
            n6 = this.codeStream.allLocalsCounter;
            while (n7 < n6) {
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n7];
                TypeBinding typeBinding = localVariableBinding.type;
                int n26 = n5 = !typeBinding.isParameterizedType() && !typeBinding.isTypeVariable() ? 0 : 1;
                if (localVariableBinding.initializationCount != 0 && n5 != 0) {
                    if (object == null) {
                        object = new LocalVariableBinding[n6];
                    }
                    object[n24++] = localVariableBinding;
                }
                n4 = 0;
                while (n4 < localVariableBinding.initializationCount) {
                    n3 = localVariableBinding.initializationPCs[n4 << 1];
                    n22 = localVariableBinding.initializationPCs[(n4 << 1) + 1];
                    if (n3 != n22) {
                        if (n22 == -1) {
                            localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                        }
                        if (n5 != 0) {
                            ++n25;
                        }
                        ++n23;
                        this.contents[n13++] = (byte)(n3 >> 8);
                        this.contents[n13++] = (byte)n3;
                        n21 = n22 - n3;
                        this.contents[n13++] = (byte)(n21 >> 8);
                        this.contents[n13++] = (byte)n21;
                        n8 = this.constantPool.literalIndex(localVariableBinding.name);
                        this.contents[n13++] = (byte)(n8 >> 8);
                        this.contents[n13++] = (byte)n8;
                        object3 = this.constantPool.literalIndex(typeBinding.signature());
                        this.contents[n13++] = (byte)(object3 >> 8);
                        this.contents[n13++] = (byte)object3;
                        n2 = localVariableBinding.resolvedPosition;
                        this.contents[n13++] = (byte)(n2 >> 8);
                        this.contents[n13++] = (byte)n2;
                    }
                    ++n4;
                }
                ++n7;
            }
            n7 = n23 * 10 + 2;
            this.contents[n9++] = (byte)(n7 >> 24);
            this.contents[n9++] = (byte)(n7 >> 16);
            this.contents[n9++] = (byte)(n7 >> 8);
            this.contents[n9++] = (byte)n7;
            this.contents[n9++] = (byte)(n23 >> 8);
            this.contents[n9] = (byte)n23;
            ++n20;
            int n27 = n6 = n11 == 0 && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
            if (n24 != 0 || n6 != 0) {
                n10 = 8 + (n25 += n6 != 0 ? 1 : 0) * 10;
                if (n13 + n10 >= this.contents.length) {
                    this.resizeContents(n10);
                }
                int n28 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n13++] = (byte)(n28 >> 8);
                this.contents[n13++] = (byte)n28;
                n7 = n25 * 10 + 2;
                this.contents[n13++] = (byte)(n7 >> 24);
                this.contents[n13++] = (byte)(n7 >> 16);
                this.contents[n13++] = (byte)(n7 >> 8);
                this.contents[n13++] = (byte)n7;
                this.contents[n13++] = (byte)(n25 >> 8);
                this.contents[n13++] = (byte)n25;
                if (n6 != 0) {
                    this.contents[n13++] = 0;
                    this.contents[n13++] = 0;
                    this.contents[n13++] = (byte)(n14 >> 8);
                    this.contents[n13++] = (byte)n14;
                    n8 = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[n13++] = (byte)(n8 >> 8);
                    this.contents[n13++] = (byte)n8;
                    object3 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                    this.contents[n13++] = (byte)(object3 >> 8);
                    this.contents[n13++] = (byte)object3;
                    this.contents[n13++] = 0;
                    this.contents[n13++] = 0;
                }
                int n29 = 0;
                while (n29 < n24) {
                    Object object5 = object[n29];
                    n4 = 0;
                    while (n4 < ((LocalVariableBinding)object5).initializationCount) {
                        n3 = ((LocalVariableBinding)object5).initializationPCs[n4 << 1];
                        n22 = ((LocalVariableBinding)object5).initializationPCs[(n4 << 1) + 1];
                        if (n3 != n22) {
                            this.contents[n13++] = (byte)(n3 >> 8);
                            this.contents[n13++] = (byte)n3;
                            n21 = n22 - n3;
                            this.contents[n13++] = (byte)(n21 >> 8);
                            this.contents[n13++] = (byte)n21;
                            n8 = this.constantPool.literalIndex(((LocalVariableBinding)object5).name);
                            this.contents[n13++] = (byte)(n8 >> 8);
                            this.contents[n13++] = (byte)n8;
                            object3 = this.constantPool.literalIndex(((LocalVariableBinding)object5).type.genericTypeSignature());
                            this.contents[n13++] = (byte)(object3 >> 8);
                            this.contents[n13++] = (byte)object3;
                            n2 = ((LocalVariableBinding)object5).resolvedPosition;
                            this.contents[n13++] = (byte)(n2 >> 8);
                            this.contents[n13++] = (byte)n2;
                        }
                        ++n4;
                    }
                    ++n29;
                }
                ++n20;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n11 = (n12 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList arrayList = new ArrayList(n12);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            n9 = n13;
            if (n13 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n13++] = (byte)(n8 >> 8);
            this.contents[n13++] = (byte)n8;
            object3 = n13;
            if ((n13 += 4) + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            n11 = 0;
            object2 = n13;
            if ((n13 += 2) + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            object = (LocalVariableBinding[])arrayList2.get(0);
            LocalVariableBinding[] localVariableBindingArray = null;
            n7 = arrayList2.size();
            n6 = 0;
            int n30 = 0;
            while (n30 < n12 && (Integer)arrayList.get(n30) < n14) {
                localVariableBindingArray = object;
                object = null;
                while (n6 < n7) {
                    object = (StackMapFrame)arrayList2.get(n6);
                    if (((StackMapFrame)object).pc == (Integer)arrayList.get(n30)) break;
                    ++n6;
                }
                if (object == null) break;
                ++n11;
                int n31 = ((StackMapFrame)object).getOffsetDelta((StackMapFrame)localVariableBindingArray);
                block0 : switch (((StackMapFrame)object).getFrameType((StackMapFrame)localVariableBindingArray)) {
                    case 2: {
                        int n32;
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n5 = ((StackMapFrame)object).numberOfDifferentLocals((StackMapFrame)localVariableBindingArray);
                        this.contents[n13++] = (byte)(251 + n5);
                        this.contents[n13++] = (byte)(n31 >> 8);
                        this.contents[n13++] = (byte)n31;
                        n4 = ((StackMapFrame)object).getIndexOfDifferentLocals(n5);
                        n3 = ((StackMapFrame)object).getNumberOfLocals();
                        int n33 = n4;
                        while (n33 < ((StackMapFrame)object).locals.length && n5 > 0) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = ((StackMapFrame)object).locals[n33]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block8 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        ++n33;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        ++n33;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n2 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n2 >> 8);
                                                this.contents[n13++] = (byte)n2;
                                                break block8;
                                            }
                                            case 7: {
                                                n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n32 >> 8);
                                                this.contents[n13++] = (byte)n32;
                                            }
                                        }
                                    }
                                }
                                --n5;
                            }
                            ++n33;
                        }
                        break;
                    }
                    case 0: {
                        if (n13 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n13++] = (byte)n31;
                        break;
                    }
                    case 3: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n13++] = -5;
                        this.contents[n13++] = (byte)(n31 >> 8);
                        this.contents[n13++] = (byte)n31;
                        break;
                    }
                    case 1: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n5 = -((StackMapFrame)object).numberOfDifferentLocals((StackMapFrame)localVariableBindingArray);
                        this.contents[n13++] = (byte)(251 - n5);
                        this.contents[n13++] = (byte)(n31 >> 8);
                        this.contents[n13++] = (byte)n31;
                        break;
                    }
                    case 5: {
                        int n32;
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n13++] = (byte)(n31 + 64);
                        if (((StackMapFrame)object).stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            break;
                        }
                        switch (((StackMapFrame)object).stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = ((StackMapFrame)object).stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n13++] = by;
                        switch (by) {
                            case 8: {
                                n2 = verificationTypeInfo.offset;
                                this.contents[n13++] = (byte)(n2 >> 8);
                                this.contents[n13++] = (byte)n2;
                                break;
                            }
                            case 7: {
                                n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n13++] = (byte)(n32 >> 8);
                                this.contents[n13++] = (byte)n32;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int n32;
                        if (n13 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n13++] = -9;
                        this.contents[n13++] = (byte)(n31 >> 8);
                        this.contents[n13++] = (byte)n31;
                        if (((StackMapFrame)object).stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            break;
                        }
                        switch (((StackMapFrame)object).stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = ((StackMapFrame)object).stackItems[0];
                        byte by = (byte)verificationTypeInfo.tag;
                        this.contents[n13++] = by;
                        switch (by) {
                            case 8: {
                                n2 = verificationTypeInfo.offset;
                                this.contents[n13++] = (byte)(n2 >> 8);
                                this.contents[n13++] = (byte)n2;
                                break;
                            }
                            case 7: {
                                n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n13++] = (byte)(n32 >> 8);
                                this.contents[n13++] = (byte)n32;
                            }
                        }
                        break;
                    }
                    default: {
                        int n34;
                        if (n13 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n13++] = -1;
                        this.contents[n13++] = (byte)(n31 >> 8);
                        this.contents[n13++] = (byte)n31;
                        int n35 = n13;
                        n13 += 2;
                        int n36 = 0;
                        n3 = ((StackMapFrame)object).getNumberOfLocals();
                        n2 = 0;
                        int n32 = ((StackMapFrame)object).locals == null ? 0 : ((StackMapFrame)object).locals.length;
                        int n37 = 0;
                        while (n37 < n32 && n36 < n3) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = ((StackMapFrame)object).locals[n37]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        ++n37;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        ++n37;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n38 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n38 >> 8);
                                                this.contents[n13++] = (byte)n38;
                                                break block41;
                                            }
                                            case 7: {
                                                n34 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n34 >> 8);
                                                this.contents[n13++] = (byte)n34;
                                            }
                                        }
                                    }
                                }
                                ++n36;
                            }
                            ++n2;
                            ++n37;
                        }
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n35++] = (byte)(n2 >> 8);
                        this.contents[n35] = (byte)n2;
                        n37 = ((StackMapFrame)object).numberOfStackItems;
                        this.contents[n13++] = (byte)(n37 >> 8);
                        this.contents[n13++] = (byte)n37;
                        int n39 = 0;
                        while (n39 < n37) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = ((StackMapFrame)object).stackItems[n39]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block52 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n34 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n34 >> 8);
                                                this.contents[n13++] = (byte)n34;
                                                break block52;
                                            }
                                            case 7: {
                                                int n40 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n40 >> 8);
                                                this.contents[n13++] = (byte)n40;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n39;
                        }
                        break block0;
                    }
                }
                ++n30;
            }
            if (n11 != 0) {
                this.contents[object2++] = (byte)(n11 >> 8);
                this.contents[object2] = (byte)n11;
                n30 = n13 - object3 - 4;
                this.contents[object3++] = (byte)(n30 >> 24);
                this.contents[object3++] = (byte)(n30 >> 16);
                this.contents[object3++] = (byte)(n30 >> 8);
                this.contents[object3] = (byte)n30;
                ++n20;
            } else {
                n13 = n9;
            }
        }
        this.contents[n19++] = (byte)(n20 >> 8);
        this.contents[n19] = (byte)n20;
        int n41 = n13 - (n + 6);
        this.contents[n + 2] = (byte)(n41 >> 24);
        this.contents[n + 3] = (byte)(n41 >> 16);
        this.contents[n + 4] = (byte)(n41 >> 8);
        this.contents[n + 5] = (byte)n41;
        this.contentsOffset = n13;
    }

    /*
     * WARNING - void declaration
     */
    public void completeCodeAttributeForClinit(int n) {
        Set set;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Object object;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Object object2;
        this.contents = this.codeStream.bCodeStream;
        int n13 = this.codeStream.classFileOffset;
        int n14 = this.codeStream.position;
        if (n14 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n13 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n15 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n15 >> 8);
        this.contents[n + 7] = (byte)n15;
        int n16 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n16 >> 8);
        this.contents[n + 9] = (byte)n16;
        this.contents[n + 10] = (byte)(n14 >> 24);
        this.contents[n + 11] = (byte)(n14 >> 16);
        this.contents[n + 12] = (byte)(n14 >> 8);
        this.contents[n + 13] = (byte)n14;
        ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
        int n17 = 0;
        int n18 = 0;
        int n19 = this.codeStream.exceptionLabelsCounter;
        while (n18 < n19) {
            n17 += this.codeStream.exceptionLabels[n18].count / 2;
            ++n18;
        }
        n18 = n17 * 8 + 2;
        if (n18 + n13 >= this.contents.length) {
            this.resizeContents(n18);
        }
        this.contents[n13++] = (byte)(n17 >> 8);
        this.contents[n13++] = (byte)n17;
        n19 = 0;
        int n20 = this.codeStream.exceptionLabelsCounter;
        while (n19 < n20) {
            object2 = exceptionLabelArray[n19];
            if (object2 != null) {
                n12 = 0;
                n11 = ((ExceptionLabel)object2).count;
                if ((n11 & 1) != 0) {
                    this.codeStream.methodDeclaration.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(this.codeStream.methodDeclaration.selector)), this.codeStream.methodDeclaration);
                }
                while (n12 < n11) {
                    n10 = ((ExceptionLabel)object2).ranges[n12++];
                    this.contents[n13++] = (byte)(n10 >> 8);
                    this.contents[n13++] = (byte)n10;
                    n9 = ((ExceptionLabel)object2).ranges[n12++];
                    this.contents[n13++] = (byte)(n9 >> 8);
                    this.contents[n13++] = (byte)n9;
                    n8 = ((ExceptionLabel)object2).position;
                    this.contents[n13++] = (byte)(n8 >> 8);
                    this.contents[n13++] = (byte)n8;
                    if (((ExceptionLabel)object2).exceptionType == null) {
                        this.contents[n13++] = 0;
                        this.contents[n13++] = 0;
                        continue;
                    }
                    object = ((ExceptionLabel)object2).exceptionType == TypeBinding.NULL ? (Object)this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName) : (Object)this.constantPool.literalIndexForType(((ExceptionLabel)object2).exceptionType.constantPoolName());
                    this.contents[n13++] = (byte)(object >> 8);
                    this.contents[n13++] = (byte)object;
                }
            }
            ++n19;
        }
        n19 = n13;
        n20 = 0;
        if ((n13 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            object2 = this.codeStream.pcToSourceMap;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                n12 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
                if (n13 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n13++] = (byte)(n12 >> 8);
                this.contents[n13++] = (byte)n12;
                n11 = n13;
                n13 += 6;
                n10 = 0;
                n9 = this.codeStream.pcToSourceMapSize;
                n8 = 0;
                while (n8 < n9) {
                    if (n13 + 4 >= this.contents.length) {
                        this.resizeContents(4);
                    }
                    object = object2[n8++];
                    this.contents[n13++] = (byte)(object >> 8);
                    this.contents[n13++] = (byte)object;
                    Object n7 = object2[n8++];
                    this.contents[n13++] = (byte)(n7 >> 8);
                    this.contents[n13++] = (byte)n7;
                    ++n10;
                }
                n8 = n10 * 4 + 2;
                this.contents[n11++] = (byte)(n8 >> 24);
                this.contents[n11++] = (byte)(n8 >> 16);
                this.contents[n11++] = (byte)(n8 >> 8);
                this.contents[n11++] = (byte)n8;
                this.contents[n11++] = (byte)(n10 >> 8);
                this.contents[n11++] = (byte)n10;
                ++n20;
            }
        }
        if ((this.produceAttributes & 4) != 0) {
            int n21 = 0;
            if (this.codeStream.pcToSourceMap != null && this.codeStream.pcToSourceMapSize != 0) {
                int verificationTypeInfo;
                void var18_27;
                n12 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
                if (n13 + 8 >= this.contents.length) {
                    this.resizeContents(8);
                }
                this.contents[n13++] = (byte)(n12 >> 8);
                this.contents[n13++] = (byte)n12;
                n11 = n13;
                n13 += 6;
                n8 = 0;
                LocalVariableBinding[] localVariableBindingArray = null;
                boolean arrayList2 = false;
                int n7 = 0;
                int n22 = this.codeStream.allLocalsCounter;
                while (n7 < n22) {
                    LocalVariableBinding n29 = this.codeStream.locals[n7];
                    TypeBinding n30 = n29.type;
                    int n23 = n6 = !n30.isParameterizedType() && !n30.isTypeVariable() ? 0 : 1;
                    if (n29.initializationCount != 0 && n6 != 0) {
                        if (localVariableBindingArray == null) {
                            localVariableBindingArray = new LocalVariableBinding[n22];
                        }
                        localVariableBindingArray[n8++] = n29;
                    }
                    n5 = 0;
                    while (n5 < n29.initializationCount) {
                        n4 = n29.initializationPCs[n5 << 1];
                        n3 = n29.initializationPCs[(n5 << 1) + 1];
                        if (n4 != n3) {
                            if (n3 == -1) {
                                n29.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(n29.name)), (ASTNode)((Object)n29.declaringScope.methodScope().referenceContext));
                            }
                            if (n13 + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++n21;
                            if (n6 != 0) {
                                ++var18_27;
                            }
                            this.contents[n13++] = (byte)(n4 >> 8);
                            this.contents[n13++] = (byte)n4;
                            n2 = n3 - n4;
                            this.contents[n13++] = (byte)(n2 >> 8);
                            this.contents[n13++] = (byte)n2;
                            n10 = this.constantPool.literalIndex(n29.name);
                            this.contents[n13++] = (byte)(n10 >> 8);
                            this.contents[n13++] = (byte)n10;
                            n9 = this.constantPool.literalIndex(n30.signature());
                            this.contents[n13++] = (byte)(n9 >> 8);
                            this.contents[n13++] = (byte)n9;
                            verificationTypeInfo = n29.resolvedPosition;
                            this.contents[n13++] = (byte)(verificationTypeInfo >> 8);
                            this.contents[n13++] = (byte)verificationTypeInfo;
                        }
                        ++n5;
                    }
                    ++n7;
                }
                n7 = n21 * 10 + 2;
                this.contents[n11++] = (byte)(n7 >> 24);
                this.contents[n11++] = (byte)(n7 >> 16);
                this.contents[n11++] = (byte)(n7 >> 8);
                this.contents[n11++] = (byte)n7;
                this.contents[n11++] = (byte)(n21 >> 8);
                this.contents[n11] = (byte)n21;
                ++n20;
                if (n8 != 0) {
                    n22 = 8 + var18_27 * 10;
                    if (n13 + n22 >= this.contents.length) {
                        this.resizeContents(n22);
                    }
                    int n24 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                    this.contents[n13++] = (byte)(n24 >> 8);
                    this.contents[n13++] = (byte)n24;
                    n7 = var18_27 * 10 + 2;
                    this.contents[n13++] = (byte)(n7 >> 24);
                    this.contents[n13++] = (byte)(n7 >> 16);
                    this.contents[n13++] = (byte)(n7 >> 8);
                    this.contents[n13++] = (byte)n7;
                    this.contents[n13++] = (byte)(var18_27 >> 8);
                    this.contents[n13++] = (byte)var18_27;
                    int n25 = 0;
                    while (n25 < n8) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[n25];
                        n5 = 0;
                        while (n5 < localVariableBinding.initializationCount) {
                            n4 = localVariableBinding.initializationPCs[n5 << 1];
                            n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                            if (n4 != n3) {
                                this.contents[n13++] = (byte)(n4 >> 8);
                                this.contents[n13++] = (byte)n4;
                                n2 = n3 - n4;
                                this.contents[n13++] = (byte)(n2 >> 8);
                                this.contents[n13++] = (byte)n2;
                                n10 = this.constantPool.literalIndex(localVariableBinding.name);
                                this.contents[n13++] = (byte)(n10 >> 8);
                                this.contents[n13++] = (byte)n10;
                                n9 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                                this.contents[n13++] = (byte)(n9 >> 8);
                                this.contents[n13++] = (byte)n9;
                                verificationTypeInfo = localVariableBinding.resolvedPosition;
                                this.contents[n13++] = (byte)(verificationTypeInfo >> 8);
                                this.contents[n13++] = (byte)verificationTypeInfo;
                            }
                            ++n5;
                        }
                        ++n25;
                    }
                    ++n20;
                }
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n11 = (n12 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList arrayList = new ArrayList(n12);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n13 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n9 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n13++] = (byte)(n9 >> 8);
            this.contents[n13++] = (byte)n9;
            n8 = n13;
            n11 = 0;
            int n28 = n13 += 4;
            n13 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n26 = arrayList2.size();
            int n27 = 0;
            n6 = 0;
            while (n6 < n12 && (Integer)arrayList.get(n6) < n14) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n27 < n26) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n27);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n6)) break;
                    ++n27;
                }
                if (stackMapFrame == null) break;
                ++n11;
                n5 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n29;
                        int n30;
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n13++] = (byte)(251 + n4);
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        n3 = stackMapFrame.getIndexOfDifferentLocals(n4);
                        n2 = stackMapFrame.getNumberOfLocals();
                        int verificationTypeInfo = n3;
                        while (verificationTypeInfo < stackMapFrame.locals.length && n4 > 0) {
                            VerificationTypeInfo n35;
                            if (n13 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((n35 = stackMapFrame.locals[verificationTypeInfo]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block8 : switch (n35.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        ++verificationTypeInfo;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        ++verificationTypeInfo;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)n35.tag;
                                        switch (n35.tag) {
                                            case 8: {
                                                n30 = n35.offset;
                                                this.contents[n13++] = (byte)(n30 >> 8);
                                                this.contents[n13++] = (byte)n30;
                                                break block8;
                                            }
                                            case 7: {
                                                n29 = this.constantPool.literalIndexForType(n35.constantPoolName());
                                                this.contents[n13++] = (byte)(n29 >> 8);
                                                this.contents[n13++] = (byte)n29;
                                            }
                                        }
                                    }
                                }
                                --n4;
                            }
                            ++verificationTypeInfo;
                        }
                        break;
                    }
                    case 0: {
                        if (n13 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n13++] = (byte)n5;
                        break;
                    }
                    case 3: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n13++] = -5;
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        break;
                    }
                    case 1: {
                        if (n13 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n13++] = (byte)(251 - n4);
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        break;
                    }
                    case 5: {
                        int n30;
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n13++] = (byte)(n5 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo n37 = stackMapFrame.stackItems[0];
                        this.contents[n13++] = (byte)n37.tag;
                        switch (n37.tag) {
                            case 8: {
                                int n38 = n37.offset;
                                this.contents[n13++] = (byte)(n38 >> 8);
                                this.contents[n13++] = (byte)n38;
                                break;
                            }
                            case 7: {
                                n30 = this.constantPool.literalIndexForType(n37.constantPoolName());
                                this.contents[n13++] = (byte)(n30 >> 8);
                                this.contents[n13++] = (byte)n30;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int n30;
                        if (n13 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n13++] = -9;
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n13++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n13++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n13++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n13++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n13++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n13++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n31 = verificationTypeInfo.offset;
                                this.contents[n13++] = (byte)(n31 >> 8);
                                this.contents[n13++] = (byte)n31;
                                break;
                            }
                            case 7: {
                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n13++] = (byte)(n30 >> 8);
                                this.contents[n13++] = (byte)n30;
                            }
                        }
                        break;
                    }
                    default: {
                        int n32;
                        if (n13 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n13++] = -1;
                        this.contents[n13++] = (byte)(n5 >> 8);
                        this.contents[n13++] = (byte)n5;
                        int n33 = n13;
                        n13 += 2;
                        int n34 = 0;
                        n2 = stackMapFrame.getNumberOfLocals();
                        int n30 = 0;
                        int n29 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n35 = 0;
                        while (n35 < n29 && n34 < n2) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n35]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        ++n35;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        ++n35;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n36 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n36 >> 8);
                                                this.contents[n13++] = (byte)n36;
                                                break block41;
                                            }
                                            case 7: {
                                                n32 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n32 >> 8);
                                                this.contents[n13++] = (byte)n32;
                                            }
                                        }
                                    }
                                }
                                ++n34;
                            }
                            ++n30;
                            ++n35;
                        }
                        if (n13 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n33++] = (byte)(n30 >> 8);
                        this.contents[n33] = (byte)n30;
                        n35 = stackMapFrame.numberOfStackItems;
                        this.contents[n13++] = (byte)(n35 >> 8);
                        this.contents[n13++] = (byte)n35;
                        int n37 = 0;
                        while (n37 < n35) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n13 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n37]) == null) {
                                this.contents[n13++] = 0;
                            } else {
                                block52 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n13++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n13++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n13++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n13++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n13++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n13++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n32 = verificationTypeInfo.offset;
                                                this.contents[n13++] = (byte)(n32 >> 8);
                                                this.contents[n13++] = (byte)n32;
                                                break block52;
                                            }
                                            case 7: {
                                                int n38 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n13++] = (byte)(n38 >> 8);
                                                this.contents[n13++] = (byte)n38;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n37;
                        }
                        break block0;
                    }
                }
                ++n6;
            }
            this.contents[n28++] = (byte)(n11 >> 8);
            this.contents[n28] = (byte)n11;
            n6 = n13 - n8 - 4;
            this.contents[n8++] = (byte)(n6 >> 24);
            this.contents[n8++] = (byte)(n6 >> 16);
            this.contents[n8++] = (byte)(n6 >> 8);
            this.contents[n8] = (byte)n6;
            ++n20;
        }
        if (n19 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n19++] = (byte)(n20 >> 8);
        this.contents[n19] = (byte)n20;
        int n43 = n13 - (n + 6);
        this.contents[n + 2] = (byte)(n43 >> 24);
        this.contents[n + 3] = (byte)(n43 >> 16);
        this.contents[n + 4] = (byte)(n43 >> 8);
        this.contents[n + 5] = (byte)n43;
        this.contentsOffset = n13;
    }

    public void completeCodeAttributeForClinit(int n, int n2) {
        Set set;
        int n3;
        int n4;
        int n5;
        this.contents = this.codeStream.bCodeStream;
        int n6 = this.codeStream.classFileOffset;
        int n7 = this.codeStream.position;
        if (n7 > 65535) {
            this.codeStream.methodDeclaration.scope.problemReporter().bytecodeExceeds64KLimit(this.codeStream.methodDeclaration.scope.referenceType());
        }
        if (n6 + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n8 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n8 >> 8);
        this.contents[n + 7] = (byte)n8;
        int n9 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n9 >> 8);
        this.contents[n + 9] = (byte)n9;
        this.contents[n + 10] = (byte)(n7 >> 24);
        this.contents[n + 11] = (byte)(n7 >> 16);
        this.contents[n + 12] = (byte)(n7 >> 8);
        this.contents[n + 13] = (byte)n7;
        this.contents[n6++] = 0;
        this.contents[n6++] = 0;
        int n10 = n6;
        int n11 = 0;
        if ((n6 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n6 + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n6++] = (byte)(n5 >> 8);
            this.contents[n6++] = (byte)n5;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 6;
            this.contents[n6++] = 0;
            this.contents[n6++] = 1;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = (byte)(n2 >> 8);
            this.contents[n6++] = (byte)n2;
            ++n11;
        }
        if ((this.produceAttributes & 4) != 0) {
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n6++] = (byte)(n5 >> 8);
            this.contents[n6++] = (byte)n5;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 2;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            ++n11;
        }
        if ((this.produceAttributes & 8) != 0 && (n4 = (n3 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList arrayList = new ArrayList(n3);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n12 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n6++] = (byte)(n12 >> 8);
            this.contents[n6++] = (byte)n12;
            int n13 = n6;
            n4 = 0;
            int n14 = n6 += 4;
            n6 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n15 = arrayList2.size();
            int n16 = 0;
            int n17 = 0;
            while (n17 < n3 && (Integer)arrayList.get(n17) < n7) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n16 < n15) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n16);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n17)) break;
                    ++n16;
                }
                if (stackMapFrame == null) break;
                ++n4;
                int n18 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n19;
                        int n20;
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n21 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 + n21);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n22 = stackMapFrame.getIndexOfDifferentLocals(n21);
                        int n23 = stackMapFrame.getNumberOfLocals();
                        int n24 = n22;
                        while (n24 < stackMapFrame.locals.length && n21 > 0) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n24]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block8 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n24;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n24;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n20 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n20 >> 8);
                                                this.contents[n6++] = (byte)n20;
                                                break block8;
                                            }
                                            case 7: {
                                                n19 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n19 >> 8);
                                                this.contents[n6++] = (byte)n19;
                                            }
                                        }
                                    }
                                }
                                --n21;
                            }
                            ++n24;
                        }
                        break;
                    }
                    case 0: {
                        if (n6 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n6++] = (byte)n18;
                        break;
                    }
                    case 3: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n6++] = -5;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        break;
                    }
                    case 1: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n21 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 - n21);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        break;
                    }
                    case 5: {
                        int n20;
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n6++] = (byte)(n18 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n25 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n25 >> 8);
                                this.contents[n6++] = (byte)n25;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int n20;
                        if (n6 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n6++] = -9;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n26 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n26 >> 8);
                                this.contents[n6++] = (byte)n26;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        break;
                    }
                    default: {
                        int n27;
                        if (n6 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n6++] = -1;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n28 = n6;
                        n6 += 2;
                        int n29 = 0;
                        int n23 = stackMapFrame.getNumberOfLocals();
                        int n20 = 0;
                        int n19 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n30 = 0;
                        while (n30 < n19 && n29 < n23) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n30]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n30;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n30;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n31 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n31 >> 8);
                                                this.contents[n6++] = (byte)n31;
                                                break block41;
                                            }
                                            case 7: {
                                                n27 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n27 >> 8);
                                                this.contents[n6++] = (byte)n27;
                                            }
                                        }
                                    }
                                }
                                ++n29;
                            }
                            ++n20;
                            ++n30;
                        }
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n28++] = (byte)(n20 >> 8);
                        this.contents[n28] = (byte)n20;
                        n30 = stackMapFrame.numberOfStackItems;
                        this.contents[n6++] = (byte)(n30 >> 8);
                        this.contents[n6++] = (byte)n30;
                        int n32 = 0;
                        while (n32 < n30) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n32]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block52 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n27 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n27 >> 8);
                                                this.contents[n6++] = (byte)n27;
                                                break block52;
                                            }
                                            case 7: {
                                                int n33 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n33 >> 8);
                                                this.contents[n6++] = (byte)n33;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n32;
                        }
                        break block0;
                    }
                }
                ++n17;
            }
            this.contents[n14++] = (byte)(n4 >> 8);
            this.contents[n14] = (byte)n4;
            n17 = n6 - n13 - 4;
            this.contents[n13++] = (byte)(n17 >> 24);
            this.contents[n13++] = (byte)(n17 >> 16);
            this.contents[n13++] = (byte)(n17 >> 8);
            this.contents[n13] = (byte)n17;
            ++n11;
        }
        if (n10 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n10++] = (byte)(n11 >> 8);
        this.contents[n10] = (byte)n11;
        int n34 = n6 - (n + 6);
        this.contents[n + 2] = (byte)(n34 >> 24);
        this.contents[n + 3] = (byte)(n34 >> 16);
        this.contents[n + 4] = (byte)(n34 >> 8);
        this.contents[n + 5] = (byte)n34;
        this.contentsOffset = n6;
    }

    public void completeCodeAttributeForMissingAbstractProblemMethod(MethodBinding methodBinding, int n, int[] nArray, int n2) {
        Set set;
        int n3;
        int n4;
        int n5;
        this.contents = this.codeStream.bCodeStream;
        int n6 = this.codeStream.classFileOffset;
        int n7 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n7 >> 8);
        this.contents[n + 7] = (byte)n7;
        int n8 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n8 >> 8);
        this.contents[n + 9] = (byte)n8;
        int n9 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n9 >> 24);
        this.contents[n + 11] = (byte)(n9 >> 16);
        this.contents[n + 12] = (byte)(n9 >> 8);
        this.contents[n + 13] = (byte)n9;
        if (n6 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n6++] = 0;
        this.contents[n6++] = 0;
        int n10 = n6;
        int n11 = 0;
        if ((n6 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n6 + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            n5 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n6++] = (byte)(n5 >> 8);
            this.contents[n6++] = (byte)n5;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = 6;
            this.contents[n6++] = 0;
            this.contents[n6++] = 1;
            if (n2 == 0) {
                n2 = ClassFile.searchLineNumber(nArray, methodBinding.sourceStart());
            }
            this.contents[n6++] = 0;
            this.contents[n6++] = 0;
            this.contents[n6++] = (byte)(n2 >> 8);
            this.contents[n6++] = (byte)n2;
            ++n11;
        }
        if ((this.produceAttributes & 8) != 0 && (n4 = (n3 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList arrayList = new ArrayList(n3);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n6 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            int n12 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n6++] = (byte)(n12 >> 8);
            this.contents[n6++] = (byte)n12;
            int n13 = n6;
            n4 = 0;
            int n14 = n6 += 4;
            n6 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n15 = arrayList2.size();
            int n16 = 0;
            int n17 = 0;
            while (n17 < n3 && (Integer)arrayList.get(n17) < n9) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n16 < n15) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n16);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n17)) break;
                    ++n16;
                }
                if (stackMapFrame == null) break;
                ++n4;
                int n18 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                block0 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n19;
                        int n20;
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n21 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 + n21);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n22 = stackMapFrame.getIndexOfDifferentLocals(n21);
                        int n23 = stackMapFrame.getNumberOfLocals();
                        int n24 = n22;
                        while (n24 < stackMapFrame.locals.length && n21 > 0) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n24]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block8 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n24;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n24;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n20 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n20 >> 8);
                                                this.contents[n6++] = (byte)n20;
                                                break block8;
                                            }
                                            case 7: {
                                                n19 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n19 >> 8);
                                                this.contents[n6++] = (byte)n19;
                                            }
                                        }
                                    }
                                }
                                --n21;
                            }
                            ++n24;
                        }
                        break;
                    }
                    case 0: {
                        if (n6 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n6++] = (byte)n18;
                        break;
                    }
                    case 3: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n6++] = -5;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        break;
                    }
                    case 1: {
                        if (n6 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n21 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n6++] = (byte)(251 - n21);
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        break;
                    }
                    case 5: {
                        int n20;
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n6++] = (byte)(n18 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n25 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n25 >> 8);
                                this.contents[n6++] = (byte)n25;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int n20;
                        if (n6 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n6++] = -9;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n6++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n6++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n6++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n6++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n6++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n6++] = 5;
                                break block0;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n26 = verificationTypeInfo.offset;
                                this.contents[n6++] = (byte)(n26 >> 8);
                                this.contents[n6++] = (byte)n26;
                                break;
                            }
                            case 7: {
                                n20 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n6++] = (byte)(n20 >> 8);
                                this.contents[n6++] = (byte)n20;
                            }
                        }
                        break;
                    }
                    default: {
                        int n27;
                        if (n6 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n6++] = -1;
                        this.contents[n6++] = (byte)(n18 >> 8);
                        this.contents[n6++] = (byte)n18;
                        int n28 = n6;
                        n6 += 2;
                        int n29 = 0;
                        int n23 = stackMapFrame.getNumberOfLocals();
                        int n20 = 0;
                        int n19 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n30 = 0;
                        while (n30 < n19 && n29 < n23) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n30]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        ++n30;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        ++n30;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n31 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n31 >> 8);
                                                this.contents[n6++] = (byte)n31;
                                                break block41;
                                            }
                                            case 7: {
                                                n27 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n27 >> 8);
                                                this.contents[n6++] = (byte)n27;
                                            }
                                        }
                                    }
                                }
                                ++n29;
                            }
                            ++n20;
                            ++n30;
                        }
                        if (n6 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n28++] = (byte)(n20 >> 8);
                        this.contents[n28] = (byte)n20;
                        n30 = stackMapFrame.numberOfStackItems;
                        this.contents[n6++] = (byte)(n30 >> 8);
                        this.contents[n6++] = (byte)n30;
                        int n32 = 0;
                        while (n32 < n30) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n6 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n32]) == null) {
                                this.contents[n6++] = 0;
                            } else {
                                block52 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n6++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n6++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n6++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n6++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n6++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n6++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n27 = verificationTypeInfo.offset;
                                                this.contents[n6++] = (byte)(n27 >> 8);
                                                this.contents[n6++] = (byte)n27;
                                                break block52;
                                            }
                                            case 7: {
                                                int n33 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n6++] = (byte)(n33 >> 8);
                                                this.contents[n6++] = (byte)n33;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n32;
                        }
                        break block0;
                    }
                }
                ++n17;
            }
            this.contents[n14++] = (byte)(n4 >> 8);
            this.contents[n14] = (byte)n4;
            n17 = n6 - n13 - 4;
            this.contents[n13++] = (byte)(n17 >> 24);
            this.contents[n13++] = (byte)(n17 >> 16);
            this.contents[n13++] = (byte)(n17 >> 8);
            this.contents[n13] = (byte)n17;
            ++n11;
        }
        if (n10 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n10++] = (byte)(n11 >> 8);
        this.contents[n10] = (byte)n11;
        n5 = n6 - (n + 6);
        this.contents[n + 2] = (byte)(n5 >> 24);
        this.contents[n + 3] = (byte)(n5 >> 16);
        this.contents[n + 4] = (byte)(n5 >> 8);
        this.contents[n + 5] = (byte)n5;
        this.contentsOffset = n6;
    }

    public void completeCodeAttributeForProblemMethod(AbstractMethodDeclaration abstractMethodDeclaration, MethodBinding methodBinding, int n, int[] nArray, int n2) {
        Set set;
        int n3;
        int n4;
        Object object;
        int n5;
        Object object2;
        int n6;
        int n7;
        Object object3;
        int n8;
        Object object4;
        int n9;
        int n10;
        int n11;
        this.contents = this.codeStream.bCodeStream;
        int n12 = this.codeStream.classFileOffset;
        int n13 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n13 >> 8);
        this.contents[n + 7] = (byte)n13;
        int n14 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n14 >> 8);
        this.contents[n + 9] = (byte)n14;
        int n15 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n15 >> 24);
        this.contents[n + 11] = (byte)(n15 >> 16);
        this.contents[n + 12] = (byte)(n15 >> 8);
        this.contents[n + 13] = (byte)n15;
        if (n12 + 50 >= this.contents.length) {
            this.resizeContents(50);
        }
        this.contents[n12++] = 0;
        this.contents[n12++] = 0;
        int n16 = n12;
        int n17 = 0;
        if ((n12 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n12 + 20 >= this.contents.length) {
                this.resizeContents(20);
            }
            n11 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n12++] = (byte)(n11 >> 8);
            this.contents[n12++] = (byte)n11;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = 6;
            this.contents[n12++] = 0;
            this.contents[n12++] = 1;
            if (n2 == 0) {
                n2 = ClassFile.searchLineNumber(nArray, methodBinding.sourceStart());
            }
            this.contents[n12++] = 0;
            this.contents[n12++] = 0;
            this.contents[n12++] = (byte)(n2 >> 8);
            this.contents[n12++] = (byte)n2;
            ++n17;
        }
        if ((this.produceAttributes & 4) != 0) {
            int n18;
            Object object5;
            Object[] objectArray;
            Object object6;
            n10 = 0;
            n9 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n12 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n12++] = (byte)(n9 >> 8);
            this.contents[n12++] = (byte)n9;
            int n19 = n12;
            n12 += 6;
            SourceTypeBinding sourceTypeBinding = null;
            boolean bl = this.codeStream.methodDeclaration.isStatic();
            if (!bl) {
                ++n10;
                if (n12 + 10 >= this.contents.length) {
                    this.resizeContents(10);
                }
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
                this.contents[n12++] = (byte)(n15 >> 8);
                this.contents[n12++] = (byte)n15;
                object4 = this.constantPool.literalIndex(ConstantPool.This);
                this.contents[n12++] = (byte)(object4 >> 8);
                this.contents[n12++] = (byte)object4;
                sourceTypeBinding = (SourceTypeBinding)this.codeStream.methodDeclaration.binding.declaringClass;
                n8 = this.constantPool.literalIndex(sourceTypeBinding.signature());
                this.contents[n12++] = (byte)(n8 >> 8);
                this.contents[n12++] = (byte)n8;
                this.contents[n12++] = 0;
                this.contents[n12++] = 0;
            }
            int n20 = 0;
            object3 = null;
            n7 = 0;
            if (methodBinding.isConstructor()) {
                ReferenceBinding referenceBinding = methodBinding.declaringClass;
                if (referenceBinding.isNestedType()) {
                    object6 = (NestedTypeBinding)referenceBinding;
                    n11 = ((NestedTypeBinding)object6).enclosingInstancesSlotSize;
                    objectArray = ((NestedTypeBinding)object6).syntheticEnclosingInstances();
                    if (objectArray != null) {
                        int n21 = 0;
                        n6 = objectArray.length;
                        while (n21 < n6) {
                            object5 = objectArray[n21];
                            object2 = object5.type;
                            if (((TypeBinding)object2).isParameterizedType() || ((TypeBinding)object2).isTypeVariable()) {
                                if (object3 == null) {
                                    object3 = new LocalVariableBinding[n6];
                                }
                                object3[n20++] = object5;
                                ++n7;
                            }
                            if (n12 + 10 >= this.contents.length) {
                                this.resizeContents(10);
                            }
                            ++n10;
                            this.contents[n12++] = 0;
                            this.contents[n12++] = 0;
                            this.contents[n12++] = (byte)(n15 >> 8);
                            this.contents[n12++] = (byte)n15;
                            object4 = this.constantPool.literalIndex(object5.name);
                            this.contents[n12++] = (byte)(object4 >> 8);
                            this.contents[n12++] = (byte)object4;
                            n8 = this.constantPool.literalIndex(((TypeBinding)object2).signature());
                            this.contents[n12++] = (byte)(n8 >> 8);
                            this.contents[n12++] = (byte)n8;
                            n18 = object5.resolvedPosition;
                            this.contents[n12++] = (byte)(n18 >> 8);
                            this.contents[n12++] = (byte)n18;
                            ++n21;
                        }
                    }
                } else {
                    n11 = 1;
                }
            } else {
                n11 = methodBinding.isStatic() ? 0 : 1;
            }
            n5 = 0;
            object6 = null;
            objectArray = null;
            TypeBinding[] typeBindingArray = null;
            if (abstractMethodDeclaration.binding != null) {
                TypeBinding[] typeBindingArray2 = abstractMethodDeclaration.binding.parameters;
                object5 = abstractMethodDeclaration.arguments;
                if (typeBindingArray2 != null && object5 != null) {
                    int n22 = 0;
                    n18 = typeBindingArray2.length;
                    while (n22 < n18) {
                        TypeBinding typeBinding = typeBindingArray2[n22];
                        if (n12 + 10 >= this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++n10;
                        this.contents[n12++] = 0;
                        this.contents[n12++] = 0;
                        this.contents[n12++] = (byte)(n15 >> 8);
                        this.contents[n12++] = (byte)n15;
                        object4 = this.constantPool.literalIndex(object5[n22].name);
                        this.contents[n12++] = (byte)(object4 >> 8);
                        this.contents[n12++] = (byte)object4;
                        object = n11;
                        if (typeBinding.isParameterizedType() || typeBinding.isTypeVariable()) {
                            if (n5 == 0) {
                                object6 = new int[n18];
                                objectArray = new int[n18];
                                typeBindingArray = new TypeBinding[n18];
                            }
                            object6[n5] = (NestedTypeBinding)object4;
                            objectArray[n5] = (SyntheticArgumentBinding)object;
                            typeBindingArray[n5++] = typeBinding;
                        }
                        n8 = this.constantPool.literalIndex(typeBinding.signature());
                        this.contents[n12++] = (byte)(n8 >> 8);
                        this.contents[n12++] = (byte)n8;
                        n11 = typeBinding == TypeBinding.LONG || typeBinding == TypeBinding.DOUBLE ? (n11 += 2) : ++n11;
                        this.contents[n12++] = (byte)(object >> 8);
                        this.contents[n12++] = (byte)object;
                        ++n22;
                    }
                }
            }
            n6 = n10 * 10 + 2;
            this.contents[n19++] = (byte)(n6 >> 24);
            this.contents[n19++] = (byte)(n6 >> 16);
            this.contents[n19++] = (byte)(n6 >> 8);
            this.contents[n19++] = (byte)n6;
            this.contents[n19++] = (byte)(n10 >> 8);
            this.contents[n19] = (byte)n10;
            ++n17;
            int n23 = n4 = !bl && sourceTypeBinding != null && sourceTypeBinding.typeVariables != Binding.NO_TYPE_VARIABLES ? 1 : 0;
            if (n20 != 0 || n5 != 0 || n4 != 0) {
                n10 = n7 + n5 + (n4 != 0 ? 1 : 0);
                int n24 = 8 + n10 * 10;
                if (n12 + n24 >= this.contents.length) {
                    this.resizeContents(n24);
                }
                n18 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n12++] = (byte)(n18 >> 8);
                this.contents[n12++] = (byte)n18;
                n6 = n10 * 10 + 2;
                this.contents[n12++] = (byte)(n6 >> 24);
                this.contents[n12++] = (byte)(n6 >> 16);
                this.contents[n12++] = (byte)(n6 >> 8);
                this.contents[n12++] = (byte)n6;
                this.contents[n12++] = (byte)(n10 >> 8);
                this.contents[n12++] = (byte)n10;
                if (n4 != 0) {
                    ++n10;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object4 = this.constantPool.literalIndex(ConstantPool.This);
                    this.contents[n12++] = (byte)(object4 >> 8);
                    this.contents[n12++] = (byte)object4;
                    n8 = this.constantPool.literalIndex(sourceTypeBinding.genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                }
                int n25 = 0;
                while (n25 < n20) {
                    LocalVariableBinding localVariableBinding = object3[n25];
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object4 = this.constantPool.literalIndex(localVariableBinding.name);
                    this.contents[n12++] = (byte)(object4 >> 8);
                    this.contents[n12++] = (byte)object4;
                    n8 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    n3 = localVariableBinding.resolvedPosition;
                    this.contents[n12++] = (byte)(n3 >> 8);
                    this.contents[n12++] = (byte)n3;
                    ++n25;
                }
                n25 = 0;
                while (n25 < n5) {
                    this.contents[n12++] = 0;
                    this.contents[n12++] = 0;
                    this.contents[n12++] = (byte)(n15 >> 8);
                    this.contents[n12++] = (byte)n15;
                    object4 = object6[n25];
                    this.contents[n12++] = (byte)(object4 >> 8);
                    this.contents[n12++] = (byte)object4;
                    n8 = this.constantPool.literalIndex(typeBindingArray[n25].genericTypeSignature());
                    this.contents[n12++] = (byte)(n8 >> 8);
                    this.contents[n12++] = (byte)n8;
                    object = objectArray[n25];
                    this.contents[n12++] = (byte)(object >> 8);
                    this.contents[n12++] = (byte)object;
                    ++n25;
                }
                ++n17;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n9 = (n10 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            ArrayList arrayList = new ArrayList(n10);
            arrayList.addAll(set);
            Collections.sort(arrayList);
            if (n12 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n8 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n12++] = (byte)(n8 >> 8);
            this.contents[n12++] = (byte)n8;
            object4 = n12;
            n9 = 0;
            int n26 = n12 += 4;
            n12 += 2;
            ArrayList arrayList2 = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList2.get(0);
            object3 = null;
            n7 = arrayList2.size();
            n5 = 0;
            int n27 = 0;
            while (n27 < n10 && (Integer)arrayList.get(n27) < n15) {
                object3 = stackMapFrame;
                stackMapFrame = null;
                while (n5 < n7) {
                    stackMapFrame = (StackMapFrame)arrayList2.get(n5);
                    if (stackMapFrame.pc == (Integer)arrayList.get(n27)) break;
                    ++n5;
                }
                if (stackMapFrame == null) break;
                ++n9;
                int n28 = stackMapFrame.getOffsetDelta((StackMapFrame)object3);
                block0 : switch (stackMapFrame.getFrameType((StackMapFrame)object3)) {
                    case 2: {
                        if (n12 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n29 = stackMapFrame.numberOfDifferentLocals((StackMapFrame)object3);
                        this.contents[n12++] = (byte)(251 + n29);
                        this.contents[n12++] = (byte)(n28 >> 8);
                        this.contents[n12++] = (byte)n28;
                        n6 = stackMapFrame.getIndexOfDifferentLocals(n29);
                        n4 = stackMapFrame.getNumberOfLocals();
                        int n30 = n6;
                        while (n30 < stackMapFrame.locals.length && n29 > 0) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n30]) == null) {
                                this.contents[n12++] = 0;
                            } else {
                                block8 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        ++n30;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        ++n30;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n31 = verificationTypeInfo.offset;
                                                this.contents[n12++] = (byte)(n31 >> 8);
                                                this.contents[n12++] = (byte)n31;
                                                break block8;
                                            }
                                            case 7: {
                                                object = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n12++] = (byte)(object >> 8);
                                                this.contents[n12++] = (byte)object;
                                            }
                                        }
                                    }
                                }
                                --n29;
                            }
                            ++n30;
                        }
                        break;
                    }
                    case 0: {
                        if (n12 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n12++] = (byte)n28;
                        break;
                    }
                    case 3: {
                        if (n12 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n12++] = -5;
                        this.contents[n12++] = (byte)(n28 >> 8);
                        this.contents[n12++] = (byte)n28;
                        break;
                    }
                    case 1: {
                        if (n12 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        int n32 = -stackMapFrame.numberOfDifferentLocals((StackMapFrame)object3);
                        this.contents[n12++] = (byte)(251 - n32);
                        this.contents[n12++] = (byte)(n28 >> 8);
                        this.contents[n12++] = (byte)n28;
                        break;
                    }
                    case 5: {
                        if (n12 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n12++] = (byte)(n28 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n12++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n12++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n12++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n12++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n12++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n12++] = 5;
                                break block0;
                            }
                        }
                        object2 = stackMapFrame.stackItems[0];
                        this.contents[n12++] = (byte)((VerificationTypeInfo)object2).tag;
                        switch (((VerificationTypeInfo)object2).tag) {
                            case 8: {
                                int n33 = ((VerificationTypeInfo)object2).offset;
                                this.contents[n12++] = (byte)(n33 >> 8);
                                this.contents[n12++] = (byte)n33;
                                break;
                            }
                            case 7: {
                                int n34 = this.constantPool.literalIndexForType(((VerificationTypeInfo)object2).constantPoolName());
                                this.contents[n12++] = (byte)(n34 >> 8);
                                this.contents[n12++] = (byte)n34;
                            }
                        }
                        break;
                    }
                    case 6: {
                        if (n12 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n12++] = -9;
                        this.contents[n12++] = (byte)(n28 >> 8);
                        this.contents[n12++] = (byte)n28;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n12++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n12++] = 1;
                                break block0;
                            }
                            case 9: {
                                this.contents[n12++] = 2;
                                break block0;
                            }
                            case 7: {
                                this.contents[n12++] = 4;
                                break block0;
                            }
                            case 8: {
                                this.contents[n12++] = 3;
                                break block0;
                            }
                            case 12: {
                                this.contents[n12++] = 5;
                                break block0;
                            }
                        }
                        object2 = stackMapFrame.stackItems[0];
                        this.contents[n12++] = (byte)((VerificationTypeInfo)object2).tag;
                        switch (((VerificationTypeInfo)object2).tag) {
                            case 8: {
                                int n35 = ((VerificationTypeInfo)object2).offset;
                                this.contents[n12++] = (byte)(n35 >> 8);
                                this.contents[n12++] = (byte)n35;
                                break;
                            }
                            case 7: {
                                int n36 = this.constantPool.literalIndexForType(((VerificationTypeInfo)object2).constantPoolName());
                                this.contents[n12++] = (byte)(n36 >> 8);
                                this.contents[n12++] = (byte)n36;
                            }
                        }
                        break;
                    }
                    default: {
                        int n37;
                        if (n12 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n12++] = -1;
                        this.contents[n12++] = (byte)(n28 >> 8);
                        this.contents[n12++] = (byte)n28;
                        int n38 = n12;
                        n12 += 2;
                        int n39 = 0;
                        n4 = stackMapFrame.getNumberOfLocals();
                        int n40 = 0;
                        object = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        n3 = 0;
                        while (n3 < object && n39 < n4) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n3]) == null) {
                                this.contents[n12++] = 0;
                            } else {
                                block41 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        ++n3;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        ++n3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n41 = verificationTypeInfo.offset;
                                                this.contents[n12++] = (byte)(n41 >> 8);
                                                this.contents[n12++] = (byte)n41;
                                                break block41;
                                            }
                                            case 7: {
                                                n37 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n12++] = (byte)(n37 >> 8);
                                                this.contents[n12++] = (byte)n37;
                                            }
                                        }
                                    }
                                }
                                ++n39;
                            }
                            ++n40;
                            ++n3;
                        }
                        if (n12 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n38++] = (byte)(n40 >> 8);
                        this.contents[n38] = (byte)n40;
                        n3 = stackMapFrame.numberOfStackItems;
                        this.contents[n12++] = (byte)(n3 >> 8);
                        this.contents[n12++] = (byte)n3;
                        int n42 = 0;
                        while (n42 < n3) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n12 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n42]) == null) {
                                this.contents[n12++] = 0;
                            } else {
                                block52 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n12++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n12++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n12++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n12++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n12++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n12++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n37 = verificationTypeInfo.offset;
                                                this.contents[n12++] = (byte)(n37 >> 8);
                                                this.contents[n12++] = (byte)n37;
                                                break block52;
                                            }
                                            case 7: {
                                                int n43 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n12++] = (byte)(n43 >> 8);
                                                this.contents[n12++] = (byte)n43;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n42;
                        }
                        break block0;
                    }
                }
                ++n27;
            }
            this.contents[n26++] = (byte)(n9 >> 8);
            this.contents[n26] = (byte)n9;
            n27 = n12 - object4 - 4;
            this.contents[object4++] = (byte)(n27 >> 24);
            this.contents[object4++] = (byte)(n27 >> 16);
            this.contents[object4++] = (byte)(n27 >> 8);
            this.contents[object4] = (byte)n27;
            ++n17;
        }
        if (n16 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n16++] = (byte)(n17 >> 8);
        this.contents[n16] = (byte)n17;
        int n44 = n12 - (n + 6);
        this.contents[n + 2] = (byte)(n44 >> 24);
        this.contents[n + 3] = (byte)(n44 >> 16);
        this.contents[n + 4] = (byte)(n44 >> 8);
        this.contents[n + 5] = (byte)n44;
        this.contentsOffset = n12;
    }

    public void completeCodeAttributeForSyntheticMethod(boolean bl, SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        Set set;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        Object object;
        int n13;
        int n14;
        int n15;
        int n16;
        this.contents = this.codeStream.bCodeStream;
        int n17 = this.codeStream.classFileOffset;
        int n18 = this.codeStream.stackMax;
        this.contents[n + 6] = (byte)(n18 >> 8);
        this.contents[n + 7] = (byte)n18;
        int n19 = this.codeStream.maxLocals;
        this.contents[n + 8] = (byte)(n19 >> 8);
        this.contents[n + 9] = (byte)n19;
        int n20 = this.codeStream.position;
        this.contents[n + 10] = (byte)(n20 >> 24);
        this.contents[n + 11] = (byte)(n20 >> 16);
        this.contents[n + 12] = (byte)(n20 >> 8);
        this.contents[n + 13] = (byte)n20;
        if (n17 + 40 >= this.contents.length) {
            this.resizeContents(40);
        }
        if (bl) {
            ExceptionLabel[] exceptionLabelArray = this.codeStream.exceptionLabels;
            n16 = 0;
            n15 = 0;
            n14 = this.codeStream.exceptionLabelsCounter;
            while (n15 < n14) {
                n16 += this.codeStream.exceptionLabels[n15].count / 2;
                ++n15;
            }
            n15 = n16 * 8 + 2;
            if (n15 + n17 >= this.contents.length) {
                this.resizeContents(n15);
            }
            this.contents[n17++] = (byte)(n16 >> 8);
            this.contents[n17++] = (byte)n16;
            n14 = 0;
            n13 = this.codeStream.exceptionLabelsCounter;
            while (n14 < n13) {
                object = exceptionLabelArray[n14];
                if (object != null) {
                    n12 = 0;
                    n11 = ((ExceptionLabel)object).count;
                    if ((n11 & 1) != 0) {
                        this.referenceBinding.scope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidExceptionAttribute, new String(syntheticMethodBinding.selector), this.referenceBinding.scope.problemReporter().referenceContext));
                    }
                    while (n12 < n11) {
                        n10 = ((ExceptionLabel)object).ranges[n12++];
                        this.contents[n17++] = (byte)(n10 >> 8);
                        this.contents[n17++] = (byte)n10;
                        n9 = ((ExceptionLabel)object).ranges[n12++];
                        this.contents[n17++] = (byte)(n9 >> 8);
                        this.contents[n17++] = (byte)n9;
                        n8 = ((ExceptionLabel)object).position;
                        this.contents[n17++] = (byte)(n8 >> 8);
                        this.contents[n17++] = (byte)n8;
                        if (((ExceptionLabel)object).exceptionType == null) {
                            this.contents[n17++] = 0;
                            this.contents[n17++] = 0;
                            continue;
                        }
                        switch (((ExceptionLabel)object).exceptionType.id) {
                            case 12: {
                                n7 = this.constantPool.literalIndexForType(ConstantPool.JavaLangClassNotFoundExceptionConstantPoolName);
                                break;
                            }
                            case 7: {
                                n7 = this.constantPool.literalIndexForType(ConstantPool.JavaLangNoSuchFieldErrorConstantPoolName);
                                break;
                            }
                            default: {
                                n7 = this.constantPool.literalIndexForType(((ExceptionLabel)object).exceptionType.constantPoolName());
                            }
                        }
                        this.contents[n17++] = (byte)(n7 >> 8);
                        this.contents[n17++] = (byte)n7;
                    }
                }
                ++n14;
            }
        } else {
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
        }
        int n21 = n17;
        n16 = 0;
        if ((n17 += 2) + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        if ((this.produceAttributes & 2) != 0) {
            if (n17 + 12 >= this.contents.length) {
                this.resizeContents(12);
            }
            n15 = 0;
            n14 = this.constantPool.literalIndex(AttributeNamesConstants.LineNumberTableName);
            this.contents[n17++] = (byte)(n14 >> 8);
            this.contents[n17++] = (byte)n14;
            n13 = n17;
            n17 += 6;
            n15 = ClassFile.searchLineNumber(nArray, syntheticMethodBinding.sourceStart);
            this.contents[n17++] = 0;
            this.contents[n17++] = 0;
            this.contents[n17++] = (byte)(n15 >> 8);
            this.contents[n17++] = (byte)n15;
            this.contents[n13++] = 0;
            this.contents[n13++] = 0;
            this.contents[n13++] = 0;
            this.contents[n13++] = 6;
            this.contents[n13++] = 0;
            this.contents[n13++] = 1;
            ++n16;
        }
        if ((this.produceAttributes & 4) != 0) {
            int n22;
            n15 = 0;
            n14 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTableName);
            if (n17 + 8 > this.contents.length) {
                this.resizeContents(8);
            }
            this.contents[n17++] = (byte)(n14 >> 8);
            this.contents[n17++] = (byte)n14;
            n13 = n17;
            n17 += 6;
            n11 = 0;
            LocalVariableBinding[] localVariableBindingArray = null;
            n9 = 0;
            n8 = 0;
            n7 = this.codeStream.allLocalsCounter;
            while (n8 < n7) {
                LocalVariableBinding localVariableBinding = this.codeStream.locals[n8];
                TypeBinding typeBinding = localVariableBinding.type;
                int n23 = n6 = !typeBinding.isParameterizedType() && !typeBinding.isTypeVariable() ? 0 : 1;
                if (localVariableBinding.initializationCount != 0 && n6 != 0) {
                    if (localVariableBindingArray == null) {
                        localVariableBindingArray = new LocalVariableBinding[n7];
                    }
                    localVariableBindingArray[n11++] = localVariableBinding;
                }
                n5 = 0;
                while (n5 < localVariableBinding.initializationCount) {
                    n4 = localVariableBinding.initializationPCs[n5 << 1];
                    n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                    if (n4 != n3) {
                        if (n3 == -1) {
                            localVariableBinding.declaringScope.problemReporter().abortDueToInternalError(Messages.bind(Messages.abort_invalidAttribute, new String(localVariableBinding.name)), (ASTNode)((Object)localVariableBinding.declaringScope.methodScope().referenceContext));
                        }
                        if (n17 + 10 > this.contents.length) {
                            this.resizeContents(10);
                        }
                        ++n15;
                        if (n6 != 0) {
                            ++n9;
                        }
                        this.contents[n17++] = (byte)(n4 >> 8);
                        this.contents[n17++] = (byte)n4;
                        n2 = n3 - n4;
                        this.contents[n17++] = (byte)(n2 >> 8);
                        this.contents[n17++] = (byte)n2;
                        int n24 = this.constantPool.literalIndex(localVariableBinding.name);
                        this.contents[n17++] = (byte)(n24 >> 8);
                        this.contents[n17++] = (byte)n24;
                        n12 = this.constantPool.literalIndex(typeBinding.signature());
                        this.contents[n17++] = (byte)(n12 >> 8);
                        this.contents[n17++] = (byte)n12;
                        n22 = localVariableBinding.resolvedPosition;
                        this.contents[n17++] = (byte)(n22 >> 8);
                        this.contents[n17++] = (byte)n22;
                    }
                    ++n5;
                }
                ++n8;
            }
            n8 = n15 * 10 + 2;
            this.contents[n13++] = (byte)(n8 >> 24);
            this.contents[n13++] = (byte)(n8 >> 16);
            this.contents[n13++] = (byte)(n8 >> 8);
            this.contents[n13++] = (byte)n8;
            this.contents[n13++] = (byte)(n15 >> 8);
            this.contents[n13] = (byte)n15;
            ++n16;
            if (n11 != 0) {
                n7 = 8 + n9 * 10;
                if (n17 + n7 >= this.contents.length) {
                    this.resizeContents(n7);
                }
                int n25 = this.constantPool.literalIndex(AttributeNamesConstants.LocalVariableTypeTableName);
                this.contents[n17++] = (byte)(n25 >> 8);
                this.contents[n17++] = (byte)n25;
                n8 = n9 * 10 + 2;
                this.contents[n17++] = (byte)(n8 >> 24);
                this.contents[n17++] = (byte)(n8 >> 16);
                this.contents[n17++] = (byte)(n8 >> 8);
                this.contents[n17++] = (byte)n8;
                this.contents[n17++] = (byte)(n9 >> 8);
                this.contents[n17++] = (byte)n9;
                int n26 = 0;
                while (n26 < n11) {
                    LocalVariableBinding localVariableBinding = localVariableBindingArray[n26];
                    n5 = 0;
                    while (n5 < localVariableBinding.initializationCount) {
                        n4 = localVariableBinding.initializationPCs[n5 << 1];
                        n3 = localVariableBinding.initializationPCs[(n5 << 1) + 1];
                        if (n4 != n3) {
                            this.contents[n17++] = (byte)(n4 >> 8);
                            this.contents[n17++] = (byte)n4;
                            n2 = n3 - n4;
                            this.contents[n17++] = (byte)(n2 >> 8);
                            this.contents[n17++] = (byte)n2;
                            int n27 = this.constantPool.literalIndex(localVariableBinding.name);
                            this.contents[n17++] = (byte)(n27 >> 8);
                            this.contents[n17++] = (byte)n27;
                            n12 = this.constantPool.literalIndex(localVariableBinding.type.genericTypeSignature());
                            this.contents[n17++] = (byte)(n12 >> 8);
                            this.contents[n17++] = (byte)n12;
                            n22 = localVariableBinding.resolvedPosition;
                            this.contents[n17++] = (byte)(n22 >> 8);
                            this.contents[n17++] = (byte)n22;
                        }
                        ++n5;
                    }
                    ++n26;
                }
                ++n16;
            }
        }
        if ((this.produceAttributes & 8) != 0 && (n13 = (n14 = (set = ((StackMapFrameCodeStream)this.codeStream).framePositions).size()) - 1) > 0) {
            object = new ArrayList(n14);
            ((ArrayList)object).addAll(set);
            Collections.sort(object);
            if (n17 + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n12 = this.constantPool.literalIndex(AttributeNamesConstants.StackMapTableName);
            this.contents[n17++] = (byte)(n12 >> 8);
            this.contents[n17++] = (byte)n12;
            n11 = n17;
            n13 = 0;
            n10 = n17 += 4;
            n17 += 2;
            ArrayList arrayList = ((StackMapFrameCodeStream)this.codeStream).frames;
            StackMapFrame stackMapFrame = (StackMapFrame)arrayList.get(0);
            StackMapFrame stackMapFrame2 = null;
            int n28 = arrayList.size();
            int n29 = 0;
            n6 = 0;
            while (n6 < n14 && (Integer)((ArrayList)object).get(n6) < n20) {
                stackMapFrame2 = stackMapFrame;
                stackMapFrame = null;
                while (n29 < n28) {
                    stackMapFrame = (StackMapFrame)arrayList.get(n29);
                    if (stackMapFrame.pc == (Integer)((ArrayList)object).get(n6)) break;
                    ++n29;
                }
                if (stackMapFrame == null) break;
                ++n13;
                n5 = stackMapFrame.getOffsetDelta(stackMapFrame2);
                block4 : switch (stackMapFrame.getFrameType(stackMapFrame2)) {
                    case 2: {
                        int n30;
                        int n31;
                        if (n17 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n17++] = (byte)(251 + n4);
                        this.contents[n17++] = (byte)(n5 >> 8);
                        this.contents[n17++] = (byte)n5;
                        n3 = stackMapFrame.getIndexOfDifferentLocals(n4);
                        n2 = stackMapFrame.getNumberOfLocals();
                        int n32 = n3;
                        while (n32 < stackMapFrame.locals.length && n4 > 0) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 6 >= this.contents.length) {
                                this.resizeContents(6);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n32]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block12 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        ++n32;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        ++n32;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n31 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n31 >> 8);
                                                this.contents[n17++] = (byte)n31;
                                                break block12;
                                            }
                                            case 7: {
                                                n30 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n30 >> 8);
                                                this.contents[n17++] = (byte)n30;
                                            }
                                        }
                                    }
                                }
                                --n4;
                            }
                            ++n32;
                        }
                        break;
                    }
                    case 0: {
                        if (n17 + 1 >= this.contents.length) {
                            this.resizeContents(1);
                        }
                        this.contents[n17++] = (byte)n5;
                        break;
                    }
                    case 3: {
                        if (n17 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        this.contents[n17++] = -5;
                        this.contents[n17++] = (byte)(n5 >> 8);
                        this.contents[n17++] = (byte)n5;
                        break;
                    }
                    case 1: {
                        if (n17 + 3 >= this.contents.length) {
                            this.resizeContents(3);
                        }
                        n4 = -stackMapFrame.numberOfDifferentLocals(stackMapFrame2);
                        this.contents[n17++] = (byte)(251 - n4);
                        this.contents[n17++] = (byte)(n5 >> 8);
                        this.contents[n17++] = (byte)n5;
                        break;
                    }
                    case 5: {
                        int n31;
                        if (n17 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n17++] = (byte)(n5 + 64);
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n17++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n17++] = 1;
                                break block4;
                            }
                            case 9: {
                                this.contents[n17++] = 2;
                                break block4;
                            }
                            case 7: {
                                this.contents[n17++] = 4;
                                break block4;
                            }
                            case 8: {
                                this.contents[n17++] = 3;
                                break block4;
                            }
                            case 12: {
                                this.contents[n17++] = 5;
                                break block4;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n33 = verificationTypeInfo.offset;
                                this.contents[n17++] = (byte)(n33 >> 8);
                                this.contents[n17++] = (byte)n33;
                                break;
                            }
                            case 7: {
                                n31 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n17++] = (byte)(n31 >> 8);
                                this.contents[n17++] = (byte)n31;
                            }
                        }
                        break;
                    }
                    case 6: {
                        int n31;
                        if (n17 + 6 >= this.contents.length) {
                            this.resizeContents(6);
                        }
                        this.contents[n17++] = -9;
                        this.contents[n17++] = (byte)(n5 >> 8);
                        this.contents[n17++] = (byte)n5;
                        if (stackMapFrame.stackItems[0] == null) {
                            this.contents[n17++] = 0;
                            break;
                        }
                        switch (stackMapFrame.stackItems[0].id()) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 10: {
                                this.contents[n17++] = 1;
                                break block4;
                            }
                            case 9: {
                                this.contents[n17++] = 2;
                                break block4;
                            }
                            case 7: {
                                this.contents[n17++] = 4;
                                break block4;
                            }
                            case 8: {
                                this.contents[n17++] = 3;
                                break block4;
                            }
                            case 12: {
                                this.contents[n17++] = 5;
                                break block4;
                            }
                        }
                        VerificationTypeInfo verificationTypeInfo = stackMapFrame.stackItems[0];
                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                        switch (verificationTypeInfo.tag) {
                            case 8: {
                                int n34 = verificationTypeInfo.offset;
                                this.contents[n17++] = (byte)(n34 >> 8);
                                this.contents[n17++] = (byte)n34;
                                break;
                            }
                            case 7: {
                                n31 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                this.contents[n17++] = (byte)(n31 >> 8);
                                this.contents[n17++] = (byte)n31;
                            }
                        }
                        break;
                    }
                    default: {
                        int n35;
                        if (n17 + 5 >= this.contents.length) {
                            this.resizeContents(5);
                        }
                        this.contents[n17++] = -1;
                        this.contents[n17++] = (byte)(n5 >> 8);
                        this.contents[n17++] = (byte)n5;
                        int n36 = n17;
                        n17 += 2;
                        int n37 = 0;
                        n2 = stackMapFrame.getNumberOfLocals();
                        int n31 = 0;
                        int n30 = stackMapFrame.locals == null ? 0 : stackMapFrame.locals.length;
                        int n38 = 0;
                        while (n38 < n30 && n37 < n2) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.locals[n38]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block45 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        ++n38;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        ++n38;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                int n39 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n39 >> 8);
                                                this.contents[n17++] = (byte)n39;
                                                break block45;
                                            }
                                            case 7: {
                                                n35 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n35 >> 8);
                                                this.contents[n17++] = (byte)n35;
                                            }
                                        }
                                    }
                                }
                                ++n37;
                            }
                            ++n31;
                            ++n38;
                        }
                        if (n17 + 4 >= this.contents.length) {
                            this.resizeContents(4);
                        }
                        this.contents[n36++] = (byte)(n31 >> 8);
                        this.contents[n36] = (byte)n31;
                        n38 = stackMapFrame.numberOfStackItems;
                        this.contents[n17++] = (byte)(n38 >> 8);
                        this.contents[n17++] = (byte)n38;
                        int n40 = 0;
                        while (n40 < n38) {
                            VerificationTypeInfo verificationTypeInfo;
                            if (n17 + 3 >= this.contents.length) {
                                this.resizeContents(3);
                            }
                            if ((verificationTypeInfo = stackMapFrame.stackItems[n40]) == null) {
                                this.contents[n17++] = 0;
                            } else {
                                block56 : switch (verificationTypeInfo.id()) {
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 10: {
                                        this.contents[n17++] = 1;
                                        break;
                                    }
                                    case 9: {
                                        this.contents[n17++] = 2;
                                        break;
                                    }
                                    case 7: {
                                        this.contents[n17++] = 4;
                                        break;
                                    }
                                    case 8: {
                                        this.contents[n17++] = 3;
                                        break;
                                    }
                                    case 12: {
                                        this.contents[n17++] = 5;
                                        break;
                                    }
                                    default: {
                                        this.contents[n17++] = (byte)verificationTypeInfo.tag;
                                        switch (verificationTypeInfo.tag) {
                                            case 8: {
                                                n35 = verificationTypeInfo.offset;
                                                this.contents[n17++] = (byte)(n35 >> 8);
                                                this.contents[n17++] = (byte)n35;
                                                break block56;
                                            }
                                            case 7: {
                                                int n41 = this.constantPool.literalIndexForType(verificationTypeInfo.constantPoolName());
                                                this.contents[n17++] = (byte)(n41 >> 8);
                                                this.contents[n17++] = (byte)n41;
                                            }
                                        }
                                    }
                                }
                            }
                            ++n40;
                        }
                        break block4;
                    }
                }
                ++n6;
            }
            this.contents[n10++] = (byte)(n13 >> 8);
            this.contents[n10] = (byte)n13;
            n6 = n17 - n11 - 4;
            this.contents[n11++] = (byte)(n6 >> 24);
            this.contents[n11++] = (byte)(n6 >> 16);
            this.contents[n11++] = (byte)(n6 >> 8);
            this.contents[n11] = (byte)n6;
            ++n16;
        }
        if (n21 + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        this.contents[n21++] = (byte)(n16 >> 8);
        this.contents[n21] = (byte)n16;
        int n42 = n17 - (n + 6);
        this.contents[n + 2] = (byte)(n42 >> 24);
        this.contents[n + 3] = (byte)(n42 >> 16);
        this.contents[n + 4] = (byte)(n42 >> 8);
        this.contents[n + 5] = (byte)n42;
        this.contentsOffset = n17;
    }

    public void completeCodeAttributeForSyntheticMethod(SyntheticMethodBinding syntheticMethodBinding, int n, int[] nArray) {
        this.completeCodeAttributeForSyntheticMethod(false, syntheticMethodBinding, n, nArray);
    }

    public void completeMethodInfo(int n, int n2) {
        this.contents[n++] = (byte)(n2 >> 8);
        this.contents[n] = (byte)n2;
    }

    public char[] fileName() {
        return this.constantPool.UTF8Cache.returnKeyFor(2);
    }

    private void generateAnnotation(Annotation annotation, int n) {
        TypeBinding typeBinding;
        if (this.contentsOffset + 4 >= this.contents.length) {
            this.resizeContents(4);
        }
        if ((typeBinding = annotation.resolvedType) == null) {
            this.contentsOffset = n;
            return;
        }
        int n2 = this.constantPool.literalIndex(typeBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            MemberValuePair[] memberValuePairArray = normalAnnotation.memberValuePairs;
            if (memberValuePairArray != null) {
                int n3 = memberValuePairArray.length;
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                int n4 = 0;
                while (n4 < n3) {
                    MemberValuePair memberValuePair = memberValuePairArray[n4];
                    if (this.contentsOffset + 2 >= this.contents.length) {
                        this.resizeContents(2);
                    }
                    int n5 = this.constantPool.literalIndex(memberValuePair.name);
                    this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n5;
                    MethodBinding methodBinding = memberValuePair.binding;
                    if (methodBinding == null) {
                        this.contentsOffset = n;
                    } else {
                        this.generateElementValue(memberValuePair.value, methodBinding.returnType, n);
                    }
                    ++n4;
                }
            } else {
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 0;
            }
        } else if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 1;
            if (this.contentsOffset + 2 >= this.contents.length) {
                this.resizeContents(2);
            }
            int n6 = this.constantPool.literalIndex(VALUE);
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            MethodBinding methodBinding = singleMemberAnnotation.memberValuePairs()[0].binding;
            if (methodBinding == null) {
                this.contentsOffset = n;
            } else {
                this.generateElementValue(singleMemberAnnotation.memberValue, methodBinding.returnType, n);
            }
        } else {
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
        }
    }

    public void generateCodeAttributeHeader() {
        if (this.contentsOffset + 20 >= this.contents.length) {
            this.resizeContents(20);
        }
        int n = this.constantPool.literalIndex(AttributeNamesConstants.CodeName);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        this.contentsOffset += 12;
    }

    private void generateElementValue(Expression expression, TypeBinding typeBinding, int n) {
        Constant constant = expression.constant;
        TypeBinding typeBinding2 = expression.resolvedType;
        if (typeBinding2 == null) {
            this.contentsOffset = n;
        } else {
            if (typeBinding.isArrayType() && !typeBinding2.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                this.contents[this.contentsOffset++] = 0;
                this.contents[this.contentsOffset++] = 1;
            }
            if (constant != null && constant != Constant.NotAConstant) {
                this.generateElementValue(n, expression, constant, typeBinding.leafComponentType());
            } else {
                this.generateElementValueForNonConstantExpression(expression, n, typeBinding2);
            }
        }
    }

    private void generateElementValue(int n, Expression expression, Constant constant, TypeBinding typeBinding) {
        if (this.contentsOffset + 3 >= this.contents.length) {
            this.resizeContents(3);
        }
        switch (typeBinding.id) {
            case 5: {
                this.contents[this.contentsOffset++] = 90;
                int n2 = this.constantPool.literalIndex(constant.booleanValue() ? 1 : 0);
                this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                this.contents[this.contentsOffset++] = (byte)n2;
                break;
            }
            case 3: {
                this.contents[this.contentsOffset++] = 66;
                int n3 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                this.contents[this.contentsOffset++] = (byte)n3;
                break;
            }
            case 2: {
                this.contents[this.contentsOffset++] = 67;
                int n4 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                this.contents[this.contentsOffset++] = (byte)n4;
                break;
            }
            case 10: {
                this.contents[this.contentsOffset++] = 73;
                int n5 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
                this.contents[this.contentsOffset++] = (byte)n5;
                break;
            }
            case 4: {
                this.contents[this.contentsOffset++] = 83;
                int n6 = this.constantPool.literalIndex(constant.intValue());
                this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                this.contents[this.contentsOffset++] = (byte)n6;
                break;
            }
            case 9: {
                this.contents[this.contentsOffset++] = 70;
                int n7 = this.constantPool.literalIndex(constant.floatValue());
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                break;
            }
            case 8: {
                this.contents[this.contentsOffset++] = 68;
                int n8 = this.constantPool.literalIndex(constant.doubleValue());
                this.contents[this.contentsOffset++] = (byte)(n8 >> 8);
                this.contents[this.contentsOffset++] = (byte)n8;
                break;
            }
            case 7: {
                this.contents[this.contentsOffset++] = 74;
                int n9 = this.constantPool.literalIndex(constant.longValue());
                this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
                this.contents[this.contentsOffset++] = (byte)n9;
                break;
            }
            case 11: {
                this.contents[this.contentsOffset++] = 115;
                int n10 = this.constantPool.literalIndex(((StringConstant)constant).stringValue().toCharArray());
                if (n10 == -1) {
                    if (!this.creatingProblemType) {
                        TypeDeclaration typeDeclaration = this.referenceBinding.scope.referenceContext;
                        typeDeclaration.scope.problemReporter().stringConstantIsExceedingUtf8Limit(expression);
                        break;
                    }
                    this.contentsOffset = n;
                    break;
                }
                this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
                this.contents[this.contentsOffset++] = (byte)n10;
            }
        }
    }

    private void generateElementValueForNonConstantExpression(Expression expression, int n, TypeBinding typeBinding) {
        if (typeBinding != null) {
            if (typeBinding.isEnum()) {
                NameReference nameReference;
                if (this.contentsOffset + 5 >= this.contents.length) {
                    this.resizeContents(5);
                }
                this.contents[this.contentsOffset++] = 101;
                FieldBinding fieldBinding = null;
                if (expression instanceof QualifiedNameReference) {
                    nameReference = (QualifiedNameReference)expression;
                    fieldBinding = (FieldBinding)nameReference.binding;
                } else if (expression instanceof SingleNameReference) {
                    nameReference = (SingleNameReference)expression;
                    fieldBinding = (FieldBinding)((SingleNameReference)nameReference).binding;
                } else {
                    this.contentsOffset = n;
                }
                if (fieldBinding != null) {
                    int n2 = this.constantPool.literalIndex(fieldBinding.type.signature());
                    int n3 = this.constantPool.literalIndex(fieldBinding.name);
                    this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n2;
                    this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n3;
                }
            } else if (typeBinding.isAnnotationType()) {
                if (this.contentsOffset + 1 >= this.contents.length) {
                    this.resizeContents(1);
                }
                this.contents[this.contentsOffset++] = 64;
                this.generateAnnotation((Annotation)expression, n);
            } else if (typeBinding.isArrayType()) {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 91;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    int n4 = arrayInitializer.expressions != null ? arrayInitializer.expressions.length : 0;
                    this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n4;
                    int n5 = 0;
                    while (n5 < n4) {
                        this.generateElementValue(arrayInitializer.expressions[n5], typeBinding.leafComponentType(), n);
                        ++n5;
                    }
                } else {
                    this.contentsOffset = n;
                }
            } else {
                if (this.contentsOffset + 3 >= this.contents.length) {
                    this.resizeContents(3);
                }
                this.contents[this.contentsOffset++] = 99;
                if (expression instanceof ClassLiteralAccess) {
                    ClassLiteralAccess classLiteralAccess = (ClassLiteralAccess)expression;
                    int n6 = this.constantPool.literalIndex(classLiteralAccess.targetType.signature());
                    this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n6;
                } else {
                    this.contentsOffset = n;
                }
            }
        } else {
            this.contentsOffset = n;
        }
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding) {
        return this.generateMethodInfoAttribute(methodBinding, false);
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, AnnotationMethodDeclaration annotationMethodDeclaration) {
        int n = this.generateMethodInfoAttribute(methodBinding);
        int n2 = this.contentsOffset;
        if ((annotationMethodDeclaration.modifiers & 0x20000) != 0) {
            int n3 = this.constantPool.literalIndex(AttributeNamesConstants.AnnotationDefaultName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            int n4 = this.contentsOffset;
            this.contentsOffset += 4;
            if (this.contentsOffset + 4 >= this.contents.length) {
                this.resizeContents(4);
            }
            this.generateElementValue(annotationMethodDeclaration.defaultValue, annotationMethodDeclaration.binding.returnType, n2);
            if (this.contentsOffset != n2) {
                int n5 = this.contentsOffset - n4 - 4;
                this.contents[n4++] = (byte)(n5 >> 24);
                this.contents[n4++] = (byte)(n5 >> 16);
                this.contents[n4++] = (byte)(n5 >> 8);
                this.contents[n4++] = (byte)n5;
                ++n;
            }
        }
        return n;
    }

    public int generateMethodInfoAttribute(MethodBinding methodBinding, boolean bl) {
        AbstractMethodDeclaration abstractMethodDeclaration;
        char[] cArray;
        int n;
        int n2;
        int n3;
        this.contentsOffset += 2;
        if (this.contentsOffset + 2 >= this.contents.length) {
            this.resizeContents(2);
        }
        int n4 = 0;
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n3 = referenceBindingArray.length;
            n2 = 8 + n3 * 2;
            if (n2 + this.contentsOffset >= this.contents.length) {
                this.resizeContents(n2);
            }
            n = this.constantPool.literalIndex(AttributeNamesConstants.ExceptionsName);
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            int n5 = n3 * 2 + 2;
            this.contents[this.contentsOffset++] = (byte)(n5 >> 24);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 16);
            this.contents[this.contentsOffset++] = (byte)(n5 >> 8);
            this.contents[this.contentsOffset++] = (byte)n5;
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            int n6 = 0;
            while (n6 < n3) {
                int n7 = this.constantPool.literalIndexForType(referenceBindingArray[n6].constantPoolName());
                this.contents[this.contentsOffset++] = (byte)(n7 >> 8);
                this.contents[this.contentsOffset++] = (byte)n7;
                ++n6;
            }
            ++n4;
        }
        if (methodBinding.isDeprecated()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.DeprecatedName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n4;
        }
        if (this.targetJDK < 0x310000L && methodBinding.isSynthetic()) {
            if (this.contentsOffset + 6 >= this.contents.length) {
                this.resizeContents(6);
            }
            n3 = this.constantPool.literalIndex(AttributeNamesConstants.SyntheticName);
            this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
            this.contents[this.contentsOffset++] = (byte)n3;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            ++n4;
        }
        if ((cArray = methodBinding.genericSignature()) != null) {
            if (this.contentsOffset + 8 >= this.contents.length) {
                this.resizeContents(8);
            }
            n2 = this.constantPool.literalIndex(AttributeNamesConstants.SignatureName);
            this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
            this.contents[this.contentsOffset++] = (byte)n2;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 0;
            this.contents[this.contentsOffset++] = 2;
            n = this.constantPool.literalIndex(cArray);
            this.contents[this.contentsOffset++] = (byte)(n >> 8);
            this.contents[this.contentsOffset++] = (byte)n;
            ++n4;
        }
        if (this.targetJDK >= 0x310000L && !this.creatingProblemType && !bl && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null) {
            Argument[] argumentArray;
            Annotation[] annotationArray = abstractMethodDeclaration.annotations;
            if (annotationArray != null) {
                n4 += this.generateRuntimeAnnotations(annotationArray);
            }
            if ((methodBinding.tagBits & 0x400L) != 0L && (argumentArray = abstractMethodDeclaration.arguments) != null) {
                n4 += this.generateRuntimeAnnotationsForParameters(argumentArray);
            }
        }
        return n4;
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding) {
        this.generateMethodInfoHeader(methodBinding, methodBinding.modifiers);
    }

    public void generateMethodInfoHeader(MethodBinding methodBinding, int n) {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        if (this.targetJDK < 0x310000L) {
            n &= 0xFFFFEFFF;
        }
        if ((methodBinding.tagBits & 0x400L) != 0L) {
            n &= 0xFFFFFFFD;
        }
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(methodBinding.selector);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = this.constantPool.literalIndex(methodBinding.signature());
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
    }

    public void generateMethodInfoHeaderForClinit() {
        ++this.methodCount;
        if (this.contentsOffset + 10 >= this.contents.length) {
            this.resizeContents(10);
        }
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 8;
        int n = this.constantPool.literalIndex(ConstantPool.Clinit);
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndex(ConstantPool.ClinitSignature);
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        this.contents[this.contentsOffset++] = 0;
        this.contents[this.contentsOffset++] = 1;
    }

    public void generateMissingAbstractMethods(MethodDeclaration[] methodDeclarationArray, CompilationResult compilationResult) {
        if (methodDeclarationArray != null) {
            int n = 0;
            int n2 = methodDeclarationArray.length;
            while (n < n2) {
                MethodDeclaration methodDeclaration = methodDeclarationArray[n];
                MethodBinding methodBinding = methodDeclaration.binding;
                String string = new String(methodBinding.readableName());
                CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                int n3 = compilationResult.problemCount;
                int n4 = 0;
                while (n4 < n3) {
                    CategorizedProblem categorizedProblem = categorizedProblemArray[n4];
                    if (categorizedProblem != null && categorizedProblem.getID() == 67109264 && categorizedProblem.getMessage().indexOf(string) != -1) {
                        this.addMissingAbstractProblemMethod(methodDeclaration, methodBinding, categorizedProblem, compilationResult);
                    }
                    ++n4;
                }
                ++n;
            }
        }
    }

    private int generateRuntimeAnnotations(Annotation[] annotationArray) {
        Annotation annotation;
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = annotationArray.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            Annotation annotation2 = annotationArray[n8];
            if (this.isRuntimeInvisible(annotation2)) {
                ++n7;
            } else if (this.isRuntimeVisible(annotation2)) {
                ++n6;
            }
            ++n8;
        }
        if (n7 != 0) {
            n8 = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int n9 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n9 >> 8);
            this.contents[this.contentsOffset++] = (byte)n9;
            n3 = this.contentsOffset;
            this.contentsOffset += 4;
            n2 = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[n2++] = (byte)(n7 >> 8);
            this.contents[n2++] = (byte)n7;
            n = 0;
            while (n < n5) {
                if (n7 == 0) break;
                annotation = annotationArray[n];
                if (this.isRuntimeInvisible(annotation)) {
                    this.generateAnnotation(annotation, n8);
                    --n7;
                    if (this.contentsOffset == n8) break;
                }
                ++n;
            }
            if (this.contentsOffset != n8) {
                n = this.contentsOffset - n3 - 4;
                this.contents[n3++] = (byte)(n >> 24);
                this.contents[n3++] = (byte)(n >> 16);
                this.contents[n3++] = (byte)(n >> 8);
                this.contents[n3++] = (byte)n;
                ++n4;
            } else {
                this.contentsOffset = n8;
            }
        }
        if (n6 != 0) {
            n8 = this.contentsOffset;
            if (this.contentsOffset + 10 >= this.contents.length) {
                this.resizeContents(10);
            }
            int n10 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
            this.contents[this.contentsOffset++] = (byte)n10;
            n3 = this.contentsOffset;
            this.contentsOffset += 4;
            n2 = this.contentsOffset;
            this.contentsOffset += 2;
            this.contents[n2++] = (byte)(n6 >> 8);
            this.contents[n2++] = (byte)n6;
            n = 0;
            while (n < n5) {
                if (n6 == 0) break;
                annotation = annotationArray[n];
                if (this.isRuntimeVisible(annotation)) {
                    --n6;
                    this.generateAnnotation(annotation, n8);
                    if (this.contentsOffset == n8) break;
                }
                ++n;
            }
            if (this.contentsOffset != n8) {
                n = this.contentsOffset - n3 - 4;
                this.contents[n3++] = (byte)(n >> 24);
                this.contents[n3++] = (byte)(n >> 16);
                this.contents[n3++] = (byte)(n >> 8);
                this.contents[n3++] = (byte)n;
                ++n4;
            } else {
                this.contentsOffset = n8;
            }
        }
        return n4;
    }

    private int generateRuntimeAnnotationsForParameters(Argument[] argumentArray) {
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        Argument argument;
        int n3;
        int n4;
        int n5 = argumentArray.length;
        int n6 = 0;
        int n7 = 0;
        int[][] nArray = new int[n5][2];
        int n8 = 0;
        while (n8 < n5) {
            Argument argument2 = argumentArray[n8];
            Annotation[] annotationArray2 = argument2.annotations;
            if (annotationArray2 != null) {
                n4 = 0;
                n3 = annotationArray2.length;
                while (n4 < n3) {
                    Annotation annotation2 = annotationArray2[n4];
                    if (this.isRuntimeInvisible(annotation2)) {
                        int[] nArray2 = nArray[n8];
                        nArray2[1] = nArray2[1] + 1;
                        ++n6;
                    } else if (this.isRuntimeVisible(annotation2)) {
                        int[] nArray3 = nArray[n8];
                        nArray3[0] = nArray3[0] + 1;
                        ++n7;
                    }
                    ++n4;
                }
            }
            ++n8;
        }
        n8 = 0;
        int n9 = this.contentsOffset;
        if (n6 != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int n10 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n10 >> 8);
            this.contents[this.contentsOffset++] = (byte)n10;
            n4 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n5;
            n3 = 0;
            block2: while (n3 < n5) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n6 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int n11 = nArray[n3][1];
                    this.contents[this.contentsOffset++] = (byte)(n11 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n11;
                    if (n11 != 0) {
                        argument = argumentArray[n3];
                        annotationArray = argument.annotations;
                        n2 = 0;
                        n = annotationArray.length;
                        while (n2 < n) {
                            annotation = annotationArray[n2];
                            if (this.isRuntimeInvisible(annotation)) {
                                this.generateAnnotation(annotation, n9);
                                if (this.contentsOffset == n9) break block2;
                                --n6;
                            }
                            ++n2;
                        }
                    }
                }
                ++n3;
            }
            if (this.contentsOffset != n9) {
                n3 = this.contentsOffset - n4 - 4;
                this.contents[n4++] = (byte)(n3 >> 24);
                this.contents[n4++] = (byte)(n3 >> 16);
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                ++n8;
            } else {
                this.contentsOffset = n9;
            }
        }
        if (n7 != 0) {
            if (this.contentsOffset + 7 >= this.contents.length) {
                this.resizeContents(7);
            }
            int n12 = this.constantPool.literalIndex(AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName);
            this.contents[this.contentsOffset++] = (byte)(n12 >> 8);
            this.contents[this.contentsOffset++] = (byte)n12;
            n4 = this.contentsOffset;
            this.contentsOffset += 4;
            this.contents[this.contentsOffset++] = (byte)n5;
            n3 = 0;
            block4: while (n3 < n5) {
                if (this.contentsOffset + 2 >= this.contents.length) {
                    this.resizeContents(2);
                }
                if (n7 == 0) {
                    this.contents[this.contentsOffset++] = 0;
                    this.contents[this.contentsOffset++] = 0;
                } else {
                    int n13 = nArray[n3][0];
                    this.contents[this.contentsOffset++] = (byte)(n13 >> 8);
                    this.contents[this.contentsOffset++] = (byte)n13;
                    if (n13 != 0) {
                        argument = argumentArray[n3];
                        annotationArray = argument.annotations;
                        n2 = 0;
                        n = annotationArray.length;
                        while (n2 < n) {
                            annotation = annotationArray[n2];
                            if (this.isRuntimeVisible(annotation)) {
                                this.generateAnnotation(annotation, n9);
                                if (this.contentsOffset == n9) break block4;
                                --n7;
                            }
                            ++n2;
                        }
                    }
                }
                ++n3;
            }
            if (this.contentsOffset != n9) {
                n3 = this.contentsOffset - n4 - 4;
                this.contents[n4++] = (byte)(n3 >> 24);
                this.contents[n4++] = (byte)(n3 >> 16);
                this.contents[n4++] = (byte)(n3 >> 8);
                this.contents[n4++] = (byte)n3;
                ++n8;
            } else {
                this.contentsOffset = n9;
            }
        }
        return n8;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = new byte[this.headerOffset + this.contentsOffset];
            System.arraycopy(this.header, 0, this.bytes, 0, this.headerOffset);
            System.arraycopy(this.contents, 0, this.bytes, this.headerOffset, this.contentsOffset);
        }
        return this.bytes;
    }

    public char[][] getCompoundName() {
        return CharOperation.splitOn('/', this.fileName());
    }

    protected void initByteArrays() {
        int n = this.referenceBinding.methods().length + this.referenceBinding.fields().length;
        this.header = new byte[1500];
        this.contents = new byte[n < 15 ? 400 : 1500];
    }

    public void initialize(SourceTypeBinding sourceTypeBinding, ClassFile classFile, boolean bl) {
        this.header[this.headerOffset++] = -54;
        this.header[this.headerOffset++] = -2;
        this.header[this.headerOffset++] = -70;
        this.header[this.headerOffset++] = -66;
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 8);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 0);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 24);
        this.header[this.headerOffset++] = (byte)(this.targetJDK >> 16);
        this.constantPoolOffset = this.headerOffset;
        this.headerOffset += 2;
        this.constantPool.initialize(this);
        int n = sourceTypeBinding.getAccessFlags();
        if (sourceTypeBinding.isPrivate()) {
            n &= 0xFFFFFFFE;
        }
        if (sourceTypeBinding.isProtected()) {
            n |= 1;
        }
        n &= 0xFFFFF6D1;
        if (!sourceTypeBinding.isInterface()) {
            n |= 0x20;
        }
        this.enclosingClassFile = classFile;
        this.contents[this.contentsOffset++] = (byte)(n >> 8);
        this.contents[this.contentsOffset++] = (byte)n;
        int n2 = this.constantPool.literalIndexForType(sourceTypeBinding.constantPoolName());
        this.contents[this.contentsOffset++] = (byte)(n2 >> 8);
        this.contents[this.contentsOffset++] = (byte)n2;
        int n3 = sourceTypeBinding.isInterface() ? this.constantPool.literalIndexForType(ConstantPool.JavaLangObjectConstantPoolName) : (sourceTypeBinding.superclass == null ? 0 : this.constantPool.literalIndexForType(sourceTypeBinding.superclass.constantPoolName()));
        this.contents[this.contentsOffset++] = (byte)(n3 >> 8);
        this.contents[this.contentsOffset++] = (byte)n3;
        ReferenceBinding[] referenceBindingArray = sourceTypeBinding.superInterfaces();
        int n4 = referenceBindingArray.length;
        this.contents[this.contentsOffset++] = (byte)(n4 >> 8);
        this.contents[this.contentsOffset++] = (byte)n4;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = this.constantPool.literalIndexForType(referenceBindingArray[n5].constantPoolName());
            this.contents[this.contentsOffset++] = (byte)(n6 >> 8);
            this.contents[this.contentsOffset++] = (byte)n6;
            ++n5;
        }
        this.innerClassesBindings = new ReferenceBinding[5];
        this.creatingProblemType = bl;
        if (this.enclosingClassFile == null) {
            this.codeStream.maxFieldCount = sourceTypeBinding.scope.referenceType().maxFieldCount;
        } else {
            ClassFile classFile2 = this.outerMostEnclosingClassFile();
            this.codeStream.maxFieldCount = classFile2.codeStream.maxFieldCount;
        }
    }

    private boolean isRuntimeInvisible(Annotation annotation) {
        TypeBinding typeBinding = annotation.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x180000000000L) == 0L) {
            return true;
        }
        return (l & 0x180000000000L) == 0x100000000000L;
    }

    private boolean isRuntimeVisible(Annotation annotation) {
        TypeBinding typeBinding = annotation.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x180000000000L) == 0L) {
            return false;
        }
        return (l & 0x180000000000L) == 0x180000000000L;
    }

    public ClassFile outerMostEnclosingClassFile() {
        ClassFile classFile = this;
        while (classFile.enclosingClassFile != null) {
            classFile = classFile.enclosingClassFile;
        }
        return classFile;
    }

    public void recordEnclosingTypeAttributes(ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2 = this.referenceBinding.enclosingType();
        int n = 0;
        while (referenceBinding2 != null) {
            ++n;
            referenceBinding2 = referenceBinding2.enclosingType();
        }
        referenceBinding2 = this.referenceBinding;
        if (n >= 2) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
            int n2 = n - 1;
            while (n2 >= 0) {
                referenceBindingArray[n2] = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
                --n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.addInnerClasses(referenceBindingArray[n2]);
                ++n2;
            }
        } else {
            this.addInnerClasses(this.referenceBinding);
        }
    }

    public void recordNestedLocalAttribute(ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2 = this.referenceBinding.enclosingType();
        int n = 0;
        while (referenceBinding2 != null) {
            ++n;
            referenceBinding2 = referenceBinding2.enclosingType();
        }
        referenceBinding2 = this.referenceBinding;
        if (n >= 2) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n];
            int n2 = n - 1;
            while (n2 >= 0) {
                referenceBindingArray[n2] = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
                --n2;
            }
            n2 = 0;
            while (n2 < n) {
                this.addInnerClasses(referenceBindingArray[n2]);
                ++n2;
            }
        } else {
            this.addInnerClasses(referenceBinding);
        }
    }

    public void recordNestedMemberAttribute(ReferenceBinding referenceBinding) {
        this.addInnerClasses(referenceBinding);
    }

    public void reset(SourceTypeBinding sourceTypeBinding) {
        CompilerOptions compilerOptions = sourceTypeBinding.scope.compilerOptions();
        this.referenceBinding = sourceTypeBinding;
        this.targetJDK = compilerOptions.targetJDK;
        this.produceAttributes = compilerOptions.produceDebugAttributes;
        if (this.targetJDK >= 0x320000L) {
            this.produceAttributes |= 8;
        }
        this.bytes = null;
        this.constantPool.reset();
        this.codeStream.reset(this);
        this.constantPoolOffset = 0;
        this.contentsOffset = 0;
        this.creatingProblemType = false;
        this.enclosingClassFile = null;
        this.headerOffset = 0;
        this.methodCount = 0;
        this.methodCountOffset = 0;
        this.numberOfInnerClasses = 0;
    }

    private final void resizeContents(int n) {
        int n2 = this.contents.length;
        int n3 = n2;
        if (n3 < n) {
            n3 = n;
        }
        this.contents = new byte[n2 + n3];
        System.arraycopy(this.contents, 0, this.contents, 0, n2);
    }

    public void setForMethodInfos() {
        this.methodCountOffset = this.contentsOffset;
        this.contentsOffset += 2;
    }
}

