/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class BreakStatement
extends BranchStatement {
    public BreakStatement(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext flowContext2;
        FlowContext flowContext3 = flowContext2 = this.label == null ? flowContext.getTargetContextForDefaultBreak() : flowContext.getTargetContextForBreakLabel(this.label);
        if (flowContext2 == null) {
            if (this.label == null) {
                blockScope.problemReporter().invalidBreak(this);
            } else {
                blockScope.problemReporter().undefinedLabel(this);
            }
            return flowInfo;
        }
        this.initStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        this.targetLabel = flowContext2.breakLabel();
        FlowContext flowContext4 = flowContext;
        int n = 0;
        this.subroutines = new SubRoutineStatement[5];
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = flowContext4.subroutine()) != null) {
                if (n == this.subroutines.length) {
                    this.subroutines = new SubRoutineStatement[n * 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
                }
                this.subroutines[n++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) break;
            }
            flowContext4.recordReturnFrom(flowInfo.unconditionalInits());
            if (flowContext4 instanceof InsideSubRoutineFlowContext) {
                ASTNode aSTNode = flowContext4.associatedNode;
                if (!(aSTNode instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)aSTNode;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                continue;
            }
            if (flowContext4 != flowContext2) continue;
            flowContext2.recordBreakFrom(flowInfo);
            break;
        } while ((flowContext4 = flowContext4.parent) != null);
        if (n != this.subroutines.length) {
            this.subroutines = new SubRoutineStatement[n];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
        }
        return FlowInfo.DEAD_END;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        BreakStatement.printIndent(n, stringBuffer).append("break ");
        if (this.label != null) {
            stringBuffer.append(this.label);
        }
        return stringBuffer.append(';');
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

