/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class IntervalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5068857361615528725L;

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            this.drawInterval(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, intervalCategoryDataset, n, n2);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
        }
    }

    protected void drawInterval(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, IntervalCategoryDataset intervalCategoryDataset, int n, int n2) {
        Object object;
        Object object2;
        double d;
        double d2;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d3 = 0.0;
        double d4 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        Number number = intervalCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d5 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge2);
        Number number2 = intervalCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d6 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
        if (d6 < d5) {
            d2 = d6;
            d6 = d5;
            d5 = d2;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        d2 = categoryItemRendererState.getBarWidth();
        double d7 = Math.abs(d6 - d5);
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
            if (n3 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d4 += (double)n * (categoryItemRendererState.getBarWidth() + d);
            } else {
                d4 += (double)n * categoryItemRendererState.getBarWidth();
            }
            d3 = d5;
            d7 = categoryItemRendererState.getBarWidth();
            d2 = Math.abs(d6 - d5);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
            if (n3 > 1) {
                d = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d3 += (double)n * (categoryItemRendererState.getBarWidth() + d);
            } else {
                d3 += (double)n * categoryItemRendererState.getBarWidth();
            }
            d4 = d5;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d4, d2, d7);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, intervalCategoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, false);
        }
        if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(intervalCategoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(intervalCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, intervalCategoryDataset, n, intervalCategoryDataset.getColumnKey(n2), n2);
            object.add(categoryItemEntity);
        }
    }
}

