/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.swixml.SwingEngine;
import org.swixml.TagLibrary;
import serpro.ppgd.gui.SplashScreen;
import serpro.ppgd.gui.xbeans.JDropDownButton;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.treeview.ArvoreGenerica;
import serpro.ppgd.infraestrutura.util.VisualizadorHelp;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.util.FabricaTratamentoErro;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.PreferenciasGlobais;

public class PgdIRPF {
    private PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
    public static Font FONTE_DEFAULT = null;
    public static int SPLIT_DIVIDER_LOCATION = 160;
    public static final String VERSAO_BETA_DESCRICAO = "<html><b>Vers\u00e3o teste do programa IRPF2007 Java</b> <br><br>A Receita Federal disponibiliza a vers\u00e3o teste do programa IRPF2007 Java, <br> para que o contribuinte possa conhecer o aplicativo com anteced\u00eancia, <br>detectar eventuais inconsist\u00eancias e fazer propostas para que o programa<br> atenda cada vez mais aos usu\u00e1rios. <br><br>As cr\u00edticas e sugest\u00f5es devem ser encaminhadas para o endere\u00e7o <br><b>irpf.beta@receita.fazenda.gov.br</b> at\u00e9 o dia 18/12/2006.</html>";
    private static boolean permiteMaisDeUmaInstanciaAplicacao = false;
    private JLabel lblSplash = new JLabel("<HTML><body bgcolor=white><IMG SRC='" + Thread.currentThread().getContextClassLoader().getResource("icones/splashirpf.gif") + "' ><br><p align=right></body></HTML>");

    public PgdIRPF() {
        SplashScreen splashScreen = new SplashScreen("/icones/splashirpf.gif", null, 20);
        this.plataforma.setSwingEngine(new SwingEngine(this));
        TagLibrary tagLibrary = this.plataforma.getSwingEngine().getTaglib();
        String string = "dropdownbutton";
        Class<JDropDownButton> clazz = JDropDownButton.class;
        tagLibrary.registerTag(string, clazz);
        this.plataforma.carrega();
        final JDropDownButton jDropDownButton = (JDropDownButton)PlataformaPPGD.getPlataforma().getSwingEngine().find("btnFichaProxima");
        final JDropDownButton jDropDownButton2 = (JDropDownButton)PlataformaPPGD.getPlataforma().getSwingEngine().find("btnFichaAnterior");
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                if (windowEvent.getOppositeWindow() == null || !windowEvent.getOppositeWindow().equals(PlataformaPPGD.getPlataforma().getJanelaPrincipal())) {
                    jDropDownButton.getPopupMenu().setVisible(false);
                    jDropDownButton2.getPopupMenu().setVisible(false);
                }
            }
        });
        this.plataforma.getJanelaPrincipal().setDefaultCloseOperation(2);
        this.plataforma.setComportamentoPadraoSair(false);
        this.plataforma.getJanelaPrincipal().addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (IRPFUtil.temDeclaracaoAberta) {
                    IRPFFacade.salvaDeclaracaoAberta();
                }
                System.out.println("Aplica\u00e7\u00e3o Encerrada");
                PgdIRPF.this.plataforma.getJanelaPrincipal().setVisible(false);
                System.exit(0);
            }
        });
        FabricaTratamentoErro.configuraTrataErroSistemico(this.plataforma.getJanelaPrincipal());
        this.plataforma.getPainelPrincipal().setBackground(new Color(255, 255, 179));
        this.plataforma.getPainelPrincipal().setBorder(BorderFactory.createLoweredBevelBorder());
        JSplitPane jSplitPane = (JSplitPane)PlataformaPPGD.getPlataforma().getComponent("splitPPGD");
        jSplitPane.setDividerLocation(SPLIT_DIVIDER_LOCATION);
        jSplitPane.setVisible(false);
        jSplitPane.setOpaque(false);
        JScrollPane jScrollPane = (JScrollPane)PlataformaPPGD.getPlataforma().getComponent("ppgdAreaArvore");
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(20);
        JScrollPane jScrollPane2 = (JScrollPane)PlataformaPPGD.getPlataforma().getComponent("ppgdScrollPnlPPGD");
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        ArvoreGenerica arvoreGenerica = (ArvoreGenerica)PlataformaPPGD.getPlataforma().getSwingEngine().find("ppgdarvore");
        arvoreGenerica.setSize(arvoreGenerica.getPreferredSize());
        this.configuraHelp();
        UIManager.getDefaults();
        splashScreen.aguardaTerminar();
        IRPFUtil.fecharDeclaracao();
        JToolBar jToolBar = (JToolBar)PlataformaPPGD.getPlataforma().getComponent("tbPPGD");
        this.ajustaBotoesToolbar(jToolBar);
        jToolBar = (JToolBar)PlataformaPPGD.getPlataforma().getComponent("tbPPGD2");
        this.ajustaBotoesToolbar(jToolBar);
        jToolBar = (JToolBar)PlataformaPPGD.getPlataforma().getComponent("tbPPGD3");
        this.ajustaBotoesToolbar(jToolBar);
        jToolBar = (JToolBar)PlataformaPPGD.getPlataforma().getComponent("tbPPGD5");
        this.ajustaBotoesToolbar(jToolBar);
        jToolBar = (JToolBar)PlataformaPPGD.getPlataforma().getComponent("tbPPGD6");
        this.ajustaBotoesToolbar(jToolBar);
        jToolBar = (JToolBar)PlataformaPPGD.getPlataforma().getComponent("tbPPGD8");
        this.ajustaBotoesToolbar(jToolBar);
        IRPFUtil.habilitaComponentesTemDeclaracao();
        this.plataforma.exibe();
    }

    private void aplicaPreferenciasIniciais() {
        PreferenciasGlobais.put("IRPF2006_PATH_APP", FabricaUtilitarios.getPathCompletoDirAplicacao());
        PreferenciasGlobais.put("IRPF2006_PATH_TRANSMITIDAS", String.valueOf(FabricaUtilitarios.getPathCompletoDirAplicacao()) + "transmitidas");
        PreferenciasGlobais.put("IRPF2006_PATH_GRAVADAS", String.valueOf(FabricaUtilitarios.getPathCompletoDirAplicacao()) + "gravadas");
        PreferenciasGlobais.put("IRPF2006_PATH_DADOS", FabricaUtilitarios.getPathCompletoDirDadosAplicacao());
    }

    private void ajustaBotoesToolbar(JToolBar jToolBar) {
        int n = jToolBar.getComponentCount() - 1;
        while (n >= 0) {
            Component component = jToolBar.getComponent(n);
            if (component instanceof JButton) {
                int n2 = 36;
                ((JButton)component).setPreferredSize(new Dimension(n2, n2));
                ((JButton)component).setSize(new Dimension(n2, n2));
                ((JButton)component).setMinimumSize(new Dimension(n2, n2));
                ((JButton)component).setMaximumSize(new Dimension(n2, n2));
            }
            --n;
        }
    }

    public static void preparaFontes() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Font font = null;
        Toolkit.getDefaultToolkit();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("SansSerif")) {
                bl2 = true;
            } else if (stringArray[n].equals("Arial")) {
                bl = true;
            } else if (stringArray[n].equals("Dialog")) {
                bl3 = true;
            }
            ++n;
        }
        font = System.getProperty("os.name").startsWith("Linux") ? (bl2 ? new Font("SansSerif", 0, 10) : (bl ? new Font("Arial", 0, 10) : (bl3 ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10)))) : (bl2 ? new Font("SansSerif", 0, 11) : (bl ? new Font("Arial", 0, 10) : (bl3 ? new Font("Dialog", 0, 10) : new Font("Default", 0, 10))));
        System.out.println("fontdefault: " + font);
        UIManager.put("Button.font", font);
        UIManager.put("RadioButton.font", font);
        UIManager.put("CheckBox.font", font);
        UIManager.put("FileChooser.font", font);
        UIManager.put("Label.font", font);
        UIManager.put("List.font", font);
        UIManager.put("RadioButtonMenuItem.font", font);
        UIManager.put("CheckBoxMenuItem.font", font);
        UIManager.put("PopupMenu.font", font);
        UIManager.put("Frame.font", font);
        UIManager.put("Panel.font", font);
        UIManager.put("ScrollPane.font", font);
        UIManager.put("Viewport.font", font);
        UIManager.put("TabbedPane.font", font);
        UIManager.put("Table.font", font);
        UIManager.put("TextField.font", font);
        UIManager.put("FormattedTextField.font", font);
        UIManager.put("TextArea.font", font);
        UIManager.put("TextPane.font", font);
        UIManager.put("EditorPane.font", font);
        UIManager.put("TitledBorder.font", font);
        UIManager.put("ToolBar.font", font);
        UIManager.put("ToolTip.font", font.deriveFont(1));
        UIManager.put("Tree.font", font);
        FONTE_DEFAULT = font;
    }

    private void configuraHelp() {
        this.plataforma.getHelp().setNavigatorVisible(false);
        this.plataforma.setHelpID("menuAjudaConteudo", "conteudo");
        this.plataforma.setHelpID("menuAjudaInstrucoes", "instrucoes");
        this.plataforma.setHelpID("menuAjudaComo", "ASSISTENTE");
        this.plataforma.setHelpID("menuAjudaErros", "erros");
        this.plataforma.setHelpID("menuAjudaPerguntas", "perguntas");
        this.plataforma.setHelpID("btnAjuda", "conteudo");
    }

    private static void executaITR() throws IOException, FileNotFoundException {
        RandomAccessFile randomAccessFile;
        FileLock fileLock;
        if (!permiteMaisDeUmaInstanciaAplicacao && (fileLock = (randomAccessFile = new RandomAccessFile("TryLock.txt", "rw")).getChannel().tryLock()) == null) {
            System.out.println("Uma inst\u00e2ncia anterior est\u00e1 em execu\u00e7\u00e3o.");
            JOptionPane.showMessageDialog(null, "Uma inst\u00e2ncia anterior da aplica\u00e7\u00e3o est\u00e1 em execu\u00e7\u00e3o", "PPGD", 2);
            System.exit(1);
        }
        new PgdIRPF();
    }

    private static void chamaHelp() {
        VisualizadorHelp visualizadorHelp = new VisualizadorHelp();
        visualizadorHelp.exibe();
        Frame.getFrames()[0].addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] stringArray) throws Exception {
        new PrintStream(new FileOutputStream("Log.txt"));
        PgdIRPF.preparaFontes();
        if (stringArray.length > 0) {
            if (stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
                PgdIRPF.chamaHelp();
            } else {
                PgdIRPF.executaITR();
            }
        } else {
            PgdIRPF.executaITR();
        }
    }
}

